/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.coreextension.util;

import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.lib.collection4.IterableUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CartesianProductUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CartesianProductUtil.class);

    private CartesianProductUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    @SafeVarargs
    public static <T> List<List<T>> cartesianProduct(T[] ... arrays) {
        List<List<T>> list = CollectionsUtil.newArrayList();
        for (T[] array : arrays) {
            list.add(ConvertUtil.toList(array));
        }
        return CartesianProductUtil.cartesianProduct(list);
    }

    @SafeVarargs
    public static <T> List<List<T>> cartesianProduct(Iterable<T> ... iterables) {
        List<Iterable<T>> list = ConvertUtil.toList(iterables);
        return CartesianProductUtil.cartesianProduct(list);
    }

    private static <T, I extends Iterable<T>> List<List<T>> cartesianProduct(Iterable<I> iterables) {
        int length = 1;
        for (Iterable iterable : iterables) {
            length *= IterableUtils.size(iterable);
        }
        ArrayList<List<T>> returnList = new ArrayList<List<T>>(length);
        for (int i = 0; i < length; ++i) {
            returnList.add(CartesianProductUtil.buildList(iterables, i));
        }
        return returnList;
    }

    private static <T, I extends Iterable<T>> List<T> buildList(Iterable<I> iterables, int i) {
        List list = CollectionsUtil.newArrayList();
        for (Iterable iterable : iterables) {
            list.add(IterableUtils.get(iterable, i % IterableUtils.size(iterable)));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(list.toString());
        }
        return list;
    }
}

