/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.coreextension.awt;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.core.net.URIUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class DesktopUtil {
    private static final boolean DESKTOP_SUPPORTED = Desktop.isDesktopSupported();

    private DesktopUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void browse(String url, Object ... args) {
        DesktopUtil.desktopAction(Slf4jUtil.format(url, args), Desktop.Action.BROWSE);
    }

    public static void open(String url, Object ... args) {
        DesktopUtil.desktopAction(Slf4jUtil.format(url, args), Desktop.Action.OPEN);
    }

    public static void mail(String mailtoURLPattern, Object ... args) {
        DesktopUtil.desktopAction(Slf4jUtil.format(mailtoURLPattern, args), Desktop.Action.MAIL);
    }

    public static void print(String url, Object ... args) {
        DesktopUtil.desktopAction(Slf4jUtil.format(url, args), Desktop.Action.PRINT);
    }

    private static void desktopAction(String url, Desktop.Action action) {
        Validate.notBlank(url, "url can't be blank!", new Object[0]);
        Validate.notNull(action, "action can't be null!", new Object[0]);
        Desktop desktop = DesktopUtil.getDesktop(action);
        try {
            switch (action) {
                case MAIL: {
                    desktop.mail(URIUtil.create(url, CharsetType.UTF8));
                    break;
                }
                case BROWSE: {
                    desktop.browse(URIUtil.create(url, CharsetType.UTF8));
                    break;
                }
                case OPEN: {
                    desktop.open(new File(url));
                    break;
                }
                case EDIT: {
                    desktop.edit(new File(url));
                    break;
                }
                case PRINT: {
                    desktop.print(new File(url));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(Slf4jUtil.format("[{}] not support!", new Object[]{action}));
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(Slf4jUtil.format("[{}],[{}]", new Object[]{url, action}), e);
        }
    }

    private static Desktop getDesktop(Desktop.Action action) {
        if (!DESKTOP_SUPPORTED) {
            throw new UnsupportedOperationException("don't Support Desktop");
        }
        Desktop desktop = Desktop.getDesktop();
        boolean supported = desktop.isSupported(action);
        if (!supported) {
            throw new UnsupportedOperationException("don't Support action:" + (Object)((Object)action));
        }
        return desktop;
    }
}

