/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util.transformer;

import com.feilong.core.Validate;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.lang.reflect.ConstructorUtil;
import java.io.Serializable;
import org.apache.commons.collections4.Transformer;

public class BeanTransformer<I, O>
implements Transformer<I, O>,
Serializable {
    private static final long serialVersionUID = -5873559262715038376L;
    private final Class<O> toBeanType;
    private final String[] includePropertyNames;

    public BeanTransformer(Class<O> toBeanType, String ... includePropertyNames) {
        Validate.notNull(toBeanType, "toBeanType can't be null!", new Object[0]);
        this.toBeanType = toBeanType;
        this.includePropertyNames = includePropertyNames;
    }

    @Override
    public O transform(I inputBean) {
        if (null == inputBean) {
            return null;
        }
        O outputBean = ConstructorUtil.newInstance(this.toBeanType, new Object[0]);
        PropertyUtil.copyProperties(outputBean, inputBean, this.includePropertyNames);
        return outputBean;
    }
}

