/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.util;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.core.lang.NumberUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.lib.collection4.IterableUtils;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;

public final class AggregateUtil {
    private AggregateUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <O> BigDecimal avg(Iterable<O> beanIterable, String propertyName, int scale) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return Validator.isNullOrEmpty(beanIterable) ? null : AggregateUtil.avg(beanIterable, ConvertUtil.toArray(propertyName), scale).get(propertyName);
    }

    public static <O> Map<String, BigDecimal> avg(Iterable<O> beanIterable, String[] propertyNames, int scale) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Map<String, BigDecimal> sumMap = AggregateUtil.sum(beanIterable, propertyNames);
        int size = IterableUtils.size(beanIterable);
        Map<String, BigDecimal> map = MapUtil.newLinkedHashMap(size);
        for (Map.Entry<String, BigDecimal> entry : sumMap.entrySet()) {
            map.put(entry.getKey(), NumberUtil.getDivideValue(ConvertUtil.toBigDecimal(entry.getValue()), size, scale));
        }
        return map;
    }

    public static <O> BigDecimal sum(Iterable<O> beanIterable, String propertyName) {
        Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        return AggregateUtil.sum(beanIterable, propertyName, null);
    }

    public static <O> BigDecimal sum(Iterable<O> beanIterable, String propertyName, Predicate<O> includePredicate) {
        Validate.notBlank(propertyName, "propertyName can't be null/empty!", new Object[0]);
        return AggregateUtil.sum(beanIterable, ConvertUtil.toArray(propertyName), includePredicate).get(propertyName);
    }

    public static <O> Map<String, BigDecimal> sum(Iterable<O> beanIterable, String ... propertyNames) {
        return AggregateUtil.sum(beanIterable, propertyNames, null);
    }

    public static <O> Map<String, BigDecimal> sum(Iterable<O> beanIterable, String[] propertyNames, Predicate<O> includePredicate) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.noNullElements(propertyNames, "propertyNames can't be null/empty!", new Object[0]);
        Map<String, BigDecimal> sumMap = MapUtil.newLinkedHashMap(IterableUtils.size(beanIterable));
        for (O obj : beanIterable) {
            if (null != includePredicate && !includePredicate.evaluate(obj)) continue;
            for (String propertyName : propertyNames) {
                BigDecimal addValue = NumberUtil.getAddValue(ObjectUtil.defaultIfNull(sumMap.get(propertyName), 0), ObjectUtil.defaultIfNull(PropertyUtil.getProperty(obj, propertyName), 0));
                sumMap.put(propertyName, addValue);
            }
        }
        return sumMap;
    }

    public static <O, T> Map<T, BigDecimal> groupSum(Iterable<O> beanIterable, String keyPropertyName, String sumPropertyName) {
        return AggregateUtil.groupSum(beanIterable, keyPropertyName, sumPropertyName, null);
    }

    public static <O, T> Map<T, BigDecimal> groupSum(Iterable<O> beanIterable, String keyPropertyName, String sumPropertyName, Predicate<O> includePredicate) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.notBlank(keyPropertyName, "keyPropertyName can't be null/empty!", new Object[0]);
        Validate.notBlank(sumPropertyName, "sumPropertyName can't be null/empty!", new Object[0]);
        Map map = MapUtil.newLinkedHashMap();
        for (O obj : beanIterable) {
            if (null != includePredicate && !includePredicate.evaluate(obj)) continue;
            Object keyPropertyValue = PropertyUtil.getProperty(obj, keyPropertyName);
            BigDecimal value = ConvertUtil.toBigDecimal(ObjectUtil.defaultIfNull(PropertyUtil.getProperty(obj, sumPropertyName), BigDecimal.ZERO));
            MapUtil.putSumValue(map, keyPropertyValue, value);
        }
        return map;
    }

    public static <O, T> Map<T, Integer> groupCount(Iterable<O> beanIterable, String propertyName) {
        return AggregateUtil.groupCount(beanIterable, propertyName, null);
    }

    public static <O, T> Map<T, Integer> groupCount(Iterable<O> beanIterable, String propertyName, Predicate<O> includePredicate) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.notBlank(propertyName, "propertyName can't be null/empty!", new Object[0]);
        Map map = MapUtil.newLinkedHashMap();
        for (O obj : beanIterable) {
            if (null != includePredicate && !includePredicate.evaluate(obj)) continue;
            MapUtil.putSumValue(map, PropertyUtil.getProperty(obj, propertyName), 1);
        }
        return map;
    }

    public static <O> Map<String, Map<Object, Integer>> groupCount(Iterable<O> beanIterable, String ... propertyNames) {
        return AggregateUtil.groupCount(beanIterable, propertyNames, (Predicate)null);
    }

    public static <O> Map<String, Map<Object, Integer>> groupCount(Iterable<O> beanIterable, String[] propertyNames, Predicate<O> includePredicate) {
        return AggregateUtil.groupCount(beanIterable, propertyNames, null, includePredicate);
    }

    public static <O> Map<String, Map<Object, Integer>> groupCount(Iterable<O> beanIterable, String[] propertyNames, Map<String, Transformer<Object, Object>> propertyValueAndTransformerMap) {
        return AggregateUtil.groupCount(beanIterable, propertyNames, propertyValueAndTransformerMap, null);
    }

    public static <O> Map<String, Map<Object, Integer>> groupCount(Iterable<O> beanIterable, String[] propertyNames, Map<String, Transformer<Object, Object>> propertyValueAndTransformerMap, Predicate<O> includePredicate) {
        if (Validator.isNullOrEmpty(beanIterable)) {
            return Collections.emptyMap();
        }
        Validate.notEmpty(propertyNames, "propertyNames can't be null/empty!", new Object[0]);
        for (String propertyName : propertyNames) {
            Validate.notBlank(propertyName, "propertyName can't be blank!", new Object[0]);
        }
        Map<String, Map<Object, Integer>> resultMap = MapUtil.newLinkedHashMap(propertyNames.length);
        for (O bean : beanIterable) {
            if (null != includePredicate && !includePredicate.evaluate(bean)) continue;
            AggregateUtil.handlerForeachPropertyNames(propertyNames, propertyValueAndTransformerMap, resultMap, bean);
        }
        return resultMap;
    }

    private static <O> void handlerForeachPropertyNames(String[] propertyNames, Map<String, Transformer<Object, Object>> propertyNameValueConverterMap, Map<String, Map<Object, Integer>> resultMap, O bean) {
        for (String propertyName : propertyNames) {
            Map propertyNameGroupCountMap = ObjectUtil.defaultIfNull(resultMap.get(propertyName), new LinkedHashMap());
            Object value = AggregateUtil.convertValue(bean, propertyName, propertyNameValueConverterMap);
            MapUtil.putSumValue(propertyNameGroupCountMap, value, 1);
            resultMap.put(propertyName, propertyNameGroupCountMap);
        }
    }

    private static <O, T> Object convertValue(O obj, String propertyName, Map<String, Transformer<Object, Object>> propertyValueAndTransformerMap) {
        Object value = PropertyUtil.getProperty(obj, propertyName);
        if (Validator.isNullOrEmpty(propertyValueAndTransformerMap)) {
            return value;
        }
        Transformer<Object, Object> transformer = propertyValueAndTransformerMap.get(propertyName);
        if (null == transformer) {
            return value;
        }
        return transformer.transform(value);
    }
}

