/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.net;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.net.ParamUtil;
import com.feilong.core.net.URIParseException;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIUtil.class);

    private URIUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static URI create(String uri) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        try {
            return URI.create(uri);
        }
        catch (Exception e) {
            throw new URIParseException(Slf4jUtil.format("input uri:[{}]", uri), e);
        }
    }

    public static URI create(String uriString, String charsetType) {
        return URIUtil.create(URIUtil.encodeUri(uriString, charsetType));
    }

    public static String encodeUri(String uriString, String charsetType) {
        Validate.notBlank(uriString, "uriString can't be null/empty!", new Object[0]);
        LOGGER.trace("input uriString:[{}],charsetType:{}", (Object)uriString, (Object)charsetType);
        if (!URIUtil.hasQueryString(uriString) || Validator.isNullOrEmpty(charsetType)) {
            return uriString;
        }
        Map<String, String[]> safeArrayValueMap = ParamUtil.toSafeArrayValueMap(URIUtil.getQueryString(uriString), charsetType);
        String encodeUrl = ParamUtil.addParameterArrayValueMap(uriString, safeArrayValueMap, charsetType);
        LOGGER.trace("input uriString:[{}],charsetType:[{}],after url:[{}]", new Object[]{uriString, charsetType, encodeUrl});
        return encodeUrl;
    }

    static String getFullPathWithoutQueryString(String uriString) {
        if (Validator.isNullOrEmpty(uriString)) {
            return "";
        }
        int index = uriString.indexOf("?");
        return index == -1 ? uriString : uriString.substring(0, index);
    }

    static String getQueryString(String uriString) {
        if (Validator.isNullOrEmpty(uriString)) {
            return "";
        }
        int index = uriString.indexOf("?");
        return index == -1 ? "" : StringUtil.substring(uriString, index + 1);
    }

    private static boolean hasQueryString(String uriString) {
        return Validator.isNotNullOrEmpty(uriString) && StringUtils.contains((CharSequence)uriString, "?");
    }

    public static String encode(String value, String charsetType) {
        return URIUtil.encodeOrDecode(value, charsetType, true);
    }

    public static String decode(String value, String charsetType) {
        return URIUtil.encodeOrDecode(value, charsetType, false);
    }

    private static String encodeOrDecode(String value, String charsetType, boolean encodeOrDecode) {
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        if (Validator.isNullOrEmpty(charsetType)) {
            return value;
        }
        try {
            return encodeOrDecode ? URLEncoder.encode(value, charsetType) : URLDecoder.decode(value, charsetType);
        }
        catch (Exception e) {
            String pattern = "[{}] value:[{}],use charset:[{}]";
            String message = Slf4jUtil.format(pattern, encodeOrDecode ? "encode" : "decode", value, charsetType);
            throw new URIParseException(message, e);
        }
    }
}

