/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang.reflect;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeUtil.class);

    private TypeUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Class<?>[] getGenericSuperclassParameterizedRawTypes(Class<?> klass) {
        Validate.notNull(klass, "klass can't be null/empty!", new Object[0]);
        ParameterizedType parameterizedType = TypeUtil.getGenericSuperclassParameterizedType(klass);
        return TypeUtil.extractActualTypeArgumentClassArray(parameterizedType);
    }

    public static Class<?>[] getGenericInterfacesParameterizedRawTypes(Class<?> klass, Class<?> extractInterfaceClass) {
        Validate.notNull(klass, "klass can't be null/empty!", new Object[0]);
        Validate.notNull(extractInterfaceClass, "extractInterfaceClass can't be null/empty!", new Object[0]);
        ParameterizedType parameterizedType = TypeUtil.getGenericInterfacesParameterizedType(klass, extractInterfaceClass);
        return TypeUtil.extractActualTypeArgumentClassArray(parameterizedType);
    }

    private static ParameterizedType getGenericInterfacesParameterizedType(Class<?> klass, Class<?> extractInterfaceClass) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = klass.getGenericInterfaces()) {
            ParameterizedType genericInterfacesType;
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || extractInterfaceClass != (rawType = (genericInterfacesType = (ParameterizedType)genericInterface).getRawType())) continue;
            return genericInterfacesType;
        }
        return null;
    }

    private static ParameterizedType getGenericSuperclassParameterizedType(Class<?> klass) {
        Class<?> useClass;
        Type type = useClass.getGenericSuperclass();
        for (useClass = klass; !(type instanceof ParameterizedType) && Object.class != useClass; useClass = useClass.getSuperclass()) {
            type = useClass.getGenericSuperclass();
        }
        return (ParameterizedType)type;
    }

    private static Class<?>[] extractActualTypeArgumentClassArray(ParameterizedType parameterizedType) {
        Validate.notNull(parameterizedType, "parameterizedType can't be null/empty!", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("parameterizedType info:[{}]", (Object)parameterizedType);
        }
        Object[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Validate.notNull(actualTypeArguments, "actualTypeArguments can't be null/empty!", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("actualTypeArguments:[{}]", (Object)ConvertUtil.toString(actualTypeArguments, ","));
        }
        return ConvertUtil.convert(actualTypeArguments, Class[].class);
    }
}

