/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.util.SortUtil;
import java.util.Map;
import java.util.Properties;

public final class SystemUtil {
    private static final String USER_HOME_KEY = "user.home";
    public static final String USER_HOME = SystemUtil.getSystemProperty("user.home");

    private SystemUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static Map<String, String> getPropertiesMap() {
        return ConvertUtil.toMap(System.getProperties());
    }

    public static Map<String, String> getEnvMap() {
        return SortUtil.sortMapByKeyAsc(System.getenv());
    }

    public static void setPropertiesFromMap(Map<String, String> map) {
        Validate.notEmpty(map, "map can't be null/empty!", new Object[0]);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    public static void setPropertiesFromProperties(Properties properties) {
        Validate.notNull(properties, "properties can't be null!", new Object[0]);
        SystemUtil.setPropertiesFromMap(ConvertUtil.toMap(properties));
    }
}

