/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ArrayUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.lib.lang3.text.StrSubstitutor;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class StringUtil {
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String LF = "\n";
    public static final String CR = "\r";

    private StringUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String newString(byte[] bytes, String charsetType) {
        return StringUtils.toEncodedString(bytes, Charset.forName(charsetType));
    }

    public static byte[] getBytes(String value) {
        Validate.notNull(value, "value can't be null!", new Object[0]);
        return value.getBytes();
    }

    public static byte[] getBytes(String value, String charsetName) {
        Validate.notNull(value, "value can't be null!", new Object[0]);
        Validate.notBlank(charsetName, "charsetName can't be blank!", new Object[0]);
        try {
            return value.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            String pattern = "value:[{}],charsetName:[{}],suggest you use [{}] constants";
            String message = Slf4jUtil.format(pattern, value, charsetName, CharsetType.class.getCanonicalName());
            throw new UncheckedIOException(message, e);
        }
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace(text, searchString, replacement);
    }

    public static String replaceAll(CharSequence content, String regex, String replacement) {
        return null == content ? EMPTY : content.toString().replaceAll(regex, replacement);
    }

    public static <V> String replace(CharSequence templateString, Map<String, V> valuesMap) {
        return StringUtils.isEmpty(templateString) ? EMPTY : StrSubstitutor.replace((Object)templateString, valuesMap);
    }

    public static String substring(String text, int beginIndex) {
        return StringUtils.substring(text, beginIndex);
    }

    public static String substring(String text, int startIndex, int length) {
        return StringUtils.substring(text, startIndex, startIndex + length);
    }

    public static String substringLast(String text, int lastLenth) {
        return StringUtils.right(text, lastLenth);
    }

    public static String substringWithoutLast(String text, int lastLenth) {
        return null == text ? EMPTY : text.substring(0, text.length() - lastLenth);
    }

    public static String substringWithoutLast(CharSequence text, String lastString) {
        if (null == text) {
            return EMPTY;
        }
        String textString = text.toString();
        if (null == lastString) {
            return textString;
        }
        return textString.endsWith(lastString) ? StringUtil.substringWithoutLast(textString, lastString.length()) : textString;
    }

    public static String[] split(String value, String regexSpliter) {
        return Validator.isNullOrEmpty(value) ? ArrayUtil.EMPTY_STRING_ARRAY : value.split(regexSpliter);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        boolean trimTokens = true;
        boolean ignoreEmptyTokens = true;
        return StringUtil.tokenizeToStringArray(str, delimiters, trimTokens, ignoreEmptyTokens);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (null == str) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        List<String> tokens = CollectionsUtil.newArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(str, delimiters);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            String string = token = trimTokens ? token.trim() : token;
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return ConvertUtil.toArray(tokens, String.class);
    }

    public static String format(String format, Object ... args) {
        return null == format ? EMPTY : String.format(format, args);
    }
}

