/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import com.feilong.core.Validator;

public final class ObjectUtil {
    private ObjectUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> T defaultIfNullOrEmpty(T object, T defaultValue) {
        return Validator.isNotNullOrEmpty(object) ? object : defaultValue;
    }

    public static <T> T defaultIfNull(T object, T defaultValue) {
        return object != null ? object : defaultValue;
    }

    public static boolean isArray(Object object) {
        Validate.notNull(object, "object can't be null!", new Object[0]);
        return object.getClass().isArray();
    }

    public static boolean isPrimitiveArray(Object object) {
        Validate.notNull(object, "object can't be null!", new Object[0]);
        return ObjectUtil.isArray(object) && object.getClass().getComponentType().isPrimitive();
    }
}

