/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.text.NumberFormatUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class NumberUtil {
    public static final int ONE = 1;
    public static final int TEN = 10;
    public static final int HUNDRED = 100;
    public static final int THOUSAND = 1000;
    public static final int TEN_THOUSAND = 10000;
    public static final int HUNDRED_THOUSAND = 100000;
    public static final int MILLION = 1000000;
    public static final int TEN_MILLION = 10000000;
    public static final int HUNDRED_MILLION = 100000000;
    public static final int BILLION = 1000000000;
    public static final long TEN_BILLION = 10000000000L;

    private NumberUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static boolean isGatherThan(Number one, Number two) {
        return NumberUtil.compare(one, two) == 1;
    }

    public static boolean isGatherThanOrEquals(Number one, Number two) {
        int compareTo = NumberUtil.compare(one, two);
        return compareTo == 1 || compareTo == 0;
    }

    public static boolean isEquals(Number one, Number two) {
        return NumberUtil.compare(one, two) == 0;
    }

    public static boolean isLessThan(Number one, Number two) {
        return NumberUtil.compare(one, two) == -1;
    }

    public static boolean isLessThanOrEquals(Number one, Number two) {
        int compareTo = NumberUtil.compare(one, two);
        return compareTo == -1 || compareTo == 0;
    }

    private static int compare(Number one, Number two) {
        Validate.notNull(one, "one can't be null!", new Object[0]);
        Validate.notNull(two, "two can't be null!", new Object[0]);
        if (one == two) {
            return 0;
        }
        return one.equals(two) ? 0 : ConvertUtil.toBigDecimal(one).compareTo(ConvertUtil.toBigDecimal(two));
    }

    public static BigDecimal getDivideValue(Number one, Number two, int scale) {
        return NumberUtil.getDivideValue(one, two, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal getDivideValue(Number one, Number two, int scale, RoundingMode roundingMode) {
        Validate.notNull(one, "one can't be null!", new Object[0]);
        Validate.notNull(two, "two can't be null!", new Object[0]);
        BigDecimal divisor = ConvertUtil.toBigDecimal(two);
        Validate.isTrue(!divisor.equals(BigDecimal.ZERO), "two can't be zero!", new Object[0]);
        return ConvertUtil.toBigDecimal(one).divide(divisor, scale, roundingMode);
    }

    public static BigDecimal getMultiplyValue(Number one, Number two, int scale) {
        Validate.notNull(one, "one can't be null!", new Object[0]);
        Validate.notNull(two, "two can't be null!", new Object[0]);
        BigDecimal multiplyValue = ConvertUtil.toBigDecimal(one).multiply(ConvertUtil.toBigDecimal(two));
        return NumberUtil.setScale(multiplyValue, scale);
    }

    public static BigDecimal getAddValue(Number ... numbers) {
        Validate.notEmpty(numbers, "numbers can't be null/empty!", new Object[0]);
        if (NumberUtil.isAllElementNull(numbers)) {
            throw new IllegalArgumentException("can not all numbers is null!");
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (Number number : numbers) {
            if (null == number) continue;
            sum = sum.add(ConvertUtil.toBigDecimal(number));
        }
        return sum;
    }

    private static boolean isAllElementNull(Number ... numbers) {
        for (Number number : numbers) {
            if (null == number) continue;
            return false;
        }
        return true;
    }

    public static BigDecimal getSubtractValue(Number beSubtractedValue, Number ... subtractions) {
        Validate.notNull(beSubtractedValue, "beSubtractedValue can't be null/empty!", new Object[0]);
        BigDecimal result = ConvertUtil.toBigDecimal(beSubtractedValue);
        if (Validator.isNullOrEmpty(subtractions)) {
            return result;
        }
        for (Number subtraction : subtractions) {
            if (null == subtraction) continue;
            result = result.subtract(ConvertUtil.toBigDecimal(subtraction));
        }
        return result;
    }

    public static String toString(Number value, String numberPattern) {
        return NumberFormatUtil.format(value, numberPattern, RoundingMode.HALF_UP);
    }

    public static String getProgress(Number current, Number total, String numberPattern) {
        Validate.notNull(current, "current can't be null/empty!", new Object[0]);
        Validate.notNull(total, "total can't be null/empty!", new Object[0]);
        Validate.isTrue(current.intValue() > 0, "current can not <=0", new Object[0]);
        Validate.isTrue(total.intValue() > 0, "total can not <=0", new Object[0]);
        Validate.isTrue(current.doubleValue() <= total.doubleValue(), "current can not > total", new Object[0]);
        int scale = 8;
        BigDecimal divideValue = NumberUtil.getDivideValue(current, total, scale);
        return NumberUtil.toString(divideValue, numberPattern);
    }

    public static BigDecimal setScale(Number value, int scale) {
        return NumberUtil.setScale(value, scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal setScale(Number value, int scale, RoundingMode roundingMode) {
        Validate.notNull(value, "value can't be null!", new Object[0]);
        return ConvertUtil.toBigDecimal(value).setScale(scale, ObjectUtil.defaultIfNull(roundingMode, RoundingMode.HALF_UP));
    }
}

