/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.lang;

import com.feilong.core.Validate;
import com.feilong.core.lang.reflect.ReflectException;
import com.feilong.lib.lang3.ClassUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.lang.reflect.Modifier;

public final class ClassUtil {
    private ClassUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static boolean isInstance(Object obj, Class<?> klass) {
        return null != klass && klass.isInstance(obj);
    }

    public static boolean isInstanceAnyClass(Object obj, Class<?> ... klasses) {
        if (null == klasses) {
            return false;
        }
        for (Class<?> klass : klasses) {
            if (!ClassUtil.isInstance(obj, klass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Class<?> klass, Class<?> cls) {
        return null != klass && null != cls && klass.isAssignableFrom(cls);
    }

    public static boolean isInterface(Class<?> ownerClass) {
        return null != ownerClass && Modifier.isInterface(ownerClass.getModifiers());
    }

    public static Class<?>[] toClass(Object ... paramValues) {
        return null == paramValues ? null : ClassUtils.toClass(paramValues);
    }

    public static Class<?> getClass(String className) {
        Validate.notBlank(className, "className can't be blank!", new Object[0]);
        try {
            return ClassUtils.getClass(className);
        }
        catch (Exception e) {
            throw new ReflectException(Slf4jUtil.format("className:[{}]", className), e);
        }
    }
}

