/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.date;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.date.CalendarUtil;
import com.feilong.core.util.ResourceBundleUtil;
import com.feilong.lib.lang3.time.DateFormatUtils;
import com.feilong.lib.lang3.time.DateUtils;
import com.feilong.lib.lang3.tuple.Pair;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public final class DateUtil {
    private static final Map<String, String> UNIT_CONFIG_MAP = ResourceBundleUtil.toMap(ResourceBundleUtil.getResourceBundle("config/feilong-dateutil"));

    private DateUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Date now() {
        return new Date();
    }

    public static String nowString(String datePattern) {
        return DateUtil.toString(DateUtil.now(), datePattern);
    }

    public static String nowTimestamp() {
        return DateUtil.nowString("yyyyMMddHHmmss");
    }

    public static Date getFirstDateOfThisDay(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        return CalendarUtil.toDate(CalendarUtil.resetDayBegin(calendar));
    }

    public static Date getLastDateOfThisDay(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        return CalendarUtil.toDate(CalendarUtil.resetDayEnd(calendar));
    }

    public static Date getFirstDateOfThisWeek(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        calendar.set(7, 1);
        return CalendarUtil.toDate(CalendarUtil.resetDayBegin(calendar));
    }

    public static Date getLastDateOfThisWeek(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        calendar.set(7, 7);
        return CalendarUtil.toDate(CalendarUtil.resetDayEnd(calendar));
    }

    public static Date getFirstDateOfThisMonth(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        calendar.set(5, 1);
        return CalendarUtil.toDate(CalendarUtil.resetDayBegin(calendar));
    }

    public static Date getLastDateOfThisMonth(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return CalendarUtil.toDate(CalendarUtil.resetDayEnd(calendar));
    }

    public static Date getFirstDateOfThisYear(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return CalendarUtil.toDate(CalendarUtil.resetDayBegin(calendar));
    }

    public static Date getLastDateOfThisYear(Date date) {
        Calendar calendar = DateUtil.toCalendar(date);
        return CalendarUtil.toDate(CalendarUtil.resetYearEnd(calendar));
    }

    public static Date addYear(Date date, int year) {
        return DateUtils.addYears(date, year);
    }

    public static Date addMonth(Date date, int month) {
        return DateUtils.addMonths(date, month);
    }

    public static Date addDay(Date date, int day) {
        return DateUtils.addDays(date, day);
    }

    public static Date addWeek(Date date, int week) {
        return DateUtils.addWeeks(date, week);
    }

    public static Date addHour(Date date, int hour) {
        return DateUtils.addHours(date, hour);
    }

    public static Date addMinute(Date date, int minute) {
        return DateUtils.addMinutes(date, minute);
    }

    public static Date addSecond(Date date, int second) {
        return DateUtils.addSeconds(date, second);
    }

    public static Date addMillisecond(Date date, int millisecond) {
        return DateUtils.addMilliseconds(date, millisecond);
    }

    public static int getYear(Date date) {
        return CalendarUtil.getFieldValue(date, 1);
    }

    public static int getMonth(Date date) {
        return 1 + CalendarUtil.getFieldValue(date, 2);
    }

    public static int getWeekOfYear(Date date) {
        return CalendarUtil.getFieldValue(date, 3);
    }

    public static int getDayOfYear(Date date) {
        return CalendarUtil.getFieldValue(date, 6);
    }

    public static int getDayOfMonth(Date date) {
        return CalendarUtil.getFieldValue(date, 5);
    }

    public static int getDayOfWeek(Date date) {
        return CalendarUtil.getFieldValue(date, 7);
    }

    public static int getHourOfYear(Date date) {
        return (DateUtil.getDayOfYear(date) - 1) * 24 + CalendarUtil.getFieldValue(date, 11);
    }

    public static int getHourOfDay(Date date) {
        return CalendarUtil.getFieldValue(date, 11);
    }

    public static int getMinute(Date date) {
        return CalendarUtil.getFieldValue(date, 12);
    }

    public static int getSecond(Date date) {
        return CalendarUtil.getFieldValue(date, 13);
    }

    public static int getSecondOfDay(Date date) {
        int hour = DateUtil.getHourOfDay(date);
        return hour * 3600 + DateUtil.getSecondOfHour(date);
    }

    public static int getSecondOfHour(Date date) {
        int minute = DateUtil.getMinute(date);
        int second = DateUtil.getSecond(date);
        return second + minute * 60;
    }

    public static long getTime(Date date) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        return date.getTime();
    }

    public static String toString(Date date, String datePattern) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        Validate.notBlank(datePattern, "datePattern can't be blank!", new Object[0]);
        return DateFormatUtils.format(date, datePattern);
    }

    public static String toString(String dateString, String oldPattern, String newPattern) {
        if (Validator.isNullOrEmpty(dateString)) {
            return null;
        }
        Validate.notBlank(oldPattern, "oldPattern can't be blank!", new Object[0]);
        Validate.notBlank(newPattern, "newPattern can't be blank!", new Object[0]);
        return DateUtil.toString(DateUtil.toDate(dateString, oldPattern), newPattern);
    }

    public static Date toDate(String dateString, String ... datePatterns) {
        Validate.notBlank(dateString, "dateString can't be blank!", new Object[0]);
        Validate.notEmpty(datePatterns, "datePatterns can't be null!", new Object[0]);
        Validate.noNullElements(datePatterns, "datePatterns can't has null datePattern", new Object[0]);
        try {
            return DateUtils.parseDate(dateString, datePatterns);
        }
        catch (ParseException e) {
            String pattern = "dateString:[{}],use patterns:[{}],parse to date exception,message:[{}]";
            throw new IllegalArgumentException(Slf4jUtil.format(pattern, dateString, datePatterns, e.getMessage()), e);
        }
    }

    static Calendar toCalendar(Date date) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        return DateUtils.toCalendar(date);
    }

    public static boolean isBefore(Date date, Date whenDate) {
        Validate.notNull(whenDate, "whenDate can't be null!", new Object[0]);
        return null != date && date.before(whenDate);
    }

    public static boolean isAfter(Date date, Date whenDate) {
        Validate.notNull(whenDate, "whenDate can't be null!", new Object[0]);
        return null != date && date.after(whenDate);
    }

    public static boolean isInTime(Date date, Date beginDate, Date endDate) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        Validate.notNull(beginDate, "beginDate can't be null!", new Object[0]);
        Validate.notNull(endDate, "endDate can't be null!", new Object[0]);
        return date.after(beginDate) && date.before(endDate);
    }

    public static boolean isInTime(String beginDateString, String endDateString, String datePattern) {
        Date now = DateUtil.now();
        return DateUtil.isInTime(now, beginDateString, endDateString, datePattern);
    }

    public static boolean isInTime(Date date, String beginDateString, String endDateString, String datePattern) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        Validate.notBlank(beginDateString, "beginDateString can't be blank!", new Object[0]);
        Validate.notBlank(endDateString, "endDateString can't be blank!", new Object[0]);
        Validate.notBlank(datePattern, "datePattern can't be blank!", new Object[0]);
        Date compareDate = DateUtil.toDate(DateUtil.toString(date, datePattern), datePattern);
        Date beginDate = DateUtil.toDate(beginDateString, datePattern);
        Date endDate = DateUtil.toDate(endDateString, datePattern);
        return DateUtil.isInTime(compareDate, beginDate, endDate);
    }

    public static boolean isToday(Date date) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        return DateUtils.isSameDay(date, DateUtil.now());
    }

    public static boolean isEquals(Date date1, Date date2, String datePattern) {
        Validate.notNull(date1, "date1 can't be null!", new Object[0]);
        Validate.notNull(date2, "date2 can't be null!", new Object[0]);
        Validate.notBlank(datePattern, "datePattern can't be blank!", new Object[0]);
        return date1 == date2 || DateUtil.toString(date1, datePattern).equals(DateUtil.toString(date2, datePattern));
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    public static Pair<Date, Date> getTodayStartAndEndPair() {
        Date date = DateUtil.now();
        return DateUtil.getDayStartAndEndPair(date);
    }

    public static Pair<Date, Date> getYesterdayStartAndEndPair() {
        Date date = DateUtil.now();
        Date yesteday = DateUtil.addDay(date, -1);
        return DateUtil.getDayStartAndEndPair(yesteday);
    }

    public static Pair<Date, Date> getDayStartAndEndPair(Date date) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        return Pair.of(DateUtil.getFirstDateOfThisDay(date), DateUtil.getLastDateOfThisDay(date));
    }

    public static Pair<Date, Date> getMonthStartAndEndPair() {
        return DateUtil.getMonthStartAndEndPair(DateUtil.now());
    }

    public static Pair<Date, Date> getMonthStartAndEndPair(Date date) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        return Pair.of(DateUtil.getFirstDateOfThisMonth(date), DateUtil.getLastDateOfThisMonth(date));
    }

    public static Pair<Date, Date> getYearStartAndEndPair() {
        return DateUtil.getYearStartAndEndPair(DateUtil.now());
    }

    public static Pair<Date, Date> getYearStartAndEndPair(Date date) {
        Validate.notNull(date, "date can't be null!", new Object[0]);
        return Pair.of(DateUtil.getFirstDateOfThisYear(date), DateUtil.getLastDateOfThisYear(date));
    }

    public static String formatDuration(Date beginDate) {
        return DateUtil.formatDuration(beginDate, DateUtil.now());
    }

    public static String formatDuration(Date beginDate, Date endDate) {
        return DateUtil.formatDuration(DateUtil.getIntervalTime(beginDate, endDate));
    }

    public static String formatDuration(long spaceMilliseconds) {
        Validate.isTrue(spaceMilliseconds >= 0L, "spaceMilliseconds can't <0", new Object[0]);
        if (0L == spaceMilliseconds) {
            return "0";
        }
        long spaceDay = DateUtil.getIntervalDay(spaceMilliseconds);
        long spaceHour = (long)DateUtil.getIntervalHour(spaceMilliseconds) - spaceDay * 24L;
        long spaceMinute = (long)DateUtil.getIntervalMinute(spaceMilliseconds) - (spaceDay * 24L + spaceHour) * 60L;
        long spaceSecond = (long)DateUtil.getIntervalSecond(spaceMilliseconds) - ((spaceDay * 24L + spaceHour) * 60L + spaceMinute) * 60L;
        long spaceMillisecond = spaceMilliseconds - (((spaceDay * 24L + spaceHour) * 60L + spaceMinute) * 60L + spaceSecond) * 1000L;
        StringBuilder sb = new StringBuilder();
        if (0L != spaceDay) {
            sb.append(spaceDay + UNIT_CONFIG_MAP.get("unitname.day"));
        }
        if (0L != spaceHour) {
            sb.append(spaceHour + UNIT_CONFIG_MAP.get("unitname.hour"));
        }
        if (0L != spaceMinute) {
            sb.append(spaceMinute + UNIT_CONFIG_MAP.get("unitname.minute"));
        }
        if (0L != spaceSecond) {
            sb.append(spaceSecond + UNIT_CONFIG_MAP.get("unitname.second"));
        }
        if (0L != spaceMillisecond) {
            sb.append(spaceMillisecond + UNIT_CONFIG_MAP.get("unitname.millisecond"));
        }
        return sb.toString();
    }

    public static int getIntervalWeek(Date date1, Date date2) {
        return DateUtil.getIntervalWeek(DateUtil.getIntervalTime(date1, date2));
    }

    private static int getIntervalWeek(long spaceTime) {
        return (int)(spaceTime / 604800000L);
    }

    public static int getIntervalDay(Date date1, Date date2) {
        return DateUtil.getIntervalDay(DateUtil.getIntervalTime(date1, date2));
    }

    private static int getIntervalDay(long spaceMilliseconds) {
        return (int)(spaceMilliseconds / 86400000L);
    }

    public static int getIntervalHour(Date date1, Date date2) {
        return DateUtil.getIntervalHour(DateUtil.getIntervalTime(date1, date2));
    }

    private static int getIntervalHour(long spaceMilliseconds) {
        return (int)(spaceMilliseconds / 3600000L);
    }

    public static int getIntervalMinute(Date date1, Date date2) {
        return DateUtil.getIntervalMinute(DateUtil.getIntervalTime(date1, date2));
    }

    private static int getIntervalMinute(long spaceMilliseconds) {
        return (int)(spaceMilliseconds / 60000L);
    }

    public static int getIntervalSecond(Date date1, Date date2) {
        return DateUtil.getIntervalSecond(DateUtil.getIntervalTime(date1, date2));
    }

    private static int getIntervalSecond(long spaceMilliseconds) {
        return (int)(spaceMilliseconds / 1000L);
    }

    public static long getIntervalTime(Date date1, Date date2) {
        Validate.notNull(date1, "date1 can't be null!", new Object[0]);
        Validate.notNull(date2, "date2 can't be null!", new Object[0]);
        return Math.abs(DateUtil.getTime(date2) - DateUtil.getTime(date1));
    }
}

