/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.date;

import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import java.util.Calendar;
import java.util.Date;

final class CalendarUtil {
    private CalendarUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static Calendar resetDayBegin(Calendar calendar) {
        Validate.notNull(calendar, "calendar can't be null!", new Object[0]);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    static Calendar resetDayEnd(Calendar calendar) {
        Validate.notNull(calendar, "calendar can't be null!", new Object[0]);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    static Calendar resetYearEnd(Calendar calendar) {
        Validate.notNull(calendar, "calendar can't be null!", new Object[0]);
        calendar.set(2, 11);
        calendar.set(5, 31);
        return CalendarUtil.resetDayEnd(calendar);
    }

    static Date toDate(Calendar calendar) {
        Validate.notNull(calendar, "calendar can't be null!", new Object[0]);
        return calendar.getTime();
    }

    static String toString(Calendar calendar, String datePattern) {
        Date date = CalendarUtil.toDate(calendar);
        return DateUtil.toString(date, datePattern);
    }

    static int getFieldValue(Date date, int field) {
        Calendar calendar = DateUtil.toCalendar(date);
        return CalendarUtil.getFieldValue(calendar, field);
    }

    static int getFieldValue(Calendar calendar, int field) {
        Validate.notNull(calendar, "calendar can't be null!", new Object[0]);
        return calendar.get(field);
    }
}

