/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.bean;

import com.feilong.core.lang.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpringBeanUtilsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBeanUtilsHelper.class);
    private static Class<?> springBeanUtilsClass = null;

    private SpringBeanUtilsHelper() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static boolean hasSpringBeanUtilsClass() {
        return springBeanUtilsClass != null;
    }

    static Class<?> getSpringBeanUtilsClass() {
        return springBeanUtilsClass;
    }

    static {
        String className = "org.springframework.beans.BeanUtils";
        try {
            springBeanUtilsClass = ClassUtil.getClass(className);
            LOGGER.trace("find and load:[{}]", (Object)className);
        }
        catch (Exception e) {
            LOGGER.warn("can't load:[{}],[{}],if you import spring, getPropertyValue will speed fast", (Object)className, (Object)e.getMessage());
        }
    }
}

