/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core.bean;

import com.feilong.core.DefaultRuntimeException;
import com.feilong.core.Validate;
import com.feilong.core.bean.BeanOperationException;
import com.feilong.core.bean.PropertyDescriptorUtil;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.lib.beanutils.MethodUtils;
import com.feilong.lib.beanutils.PropertyUtils;
import com.feilong.lib.collection4.IterableUtils;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyValueObtainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyValueObtainer.class);

    private PropertyValueObtainer() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static <T> T obtain(Object bean, String propertyName) {
        if (PropertyDescriptorUtil.isUseSpringOperate(bean.getClass(), propertyName)) {
            return PropertyValueObtainer.getDataUseSpring(bean, propertyName);
        }
        return PropertyValueObtainer.getDataUseApache(bean, propertyName);
    }

    private static <T> T getDataUseApache(Object bean, String propertyName) {
        try {
            return (T)PropertyUtils.getProperty(bean, propertyName);
        }
        catch (Exception e) {
            String pattern = "getProperty exception,bean:[{}],propertyName:[{}]";
            throw new BeanOperationException(Slf4jUtil.format(pattern, bean, propertyName), e);
        }
    }

    private static <T> T getDataUseSpring(Object bean, String propertyName) {
        LOGGER.trace("will use spring beanutils to execute:[{}],propertyName:[{}]", bean, (Object)propertyName);
        try {
            PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getSpringPropertyDescriptor(bean.getClass(), propertyName);
            return PropertyValueObtainer.getValue(bean, propertyDescriptor);
        }
        catch (Exception e) {
            String pattern = "getProperty exception,bean:[{}],propertyName:[{}]";
            throw new BeanOperationException(Slf4jUtil.format(pattern, bean, propertyName), e);
        }
    }

    public static <T, O, K extends Collection<T>> K getPropertyValueCollection(Iterable<O> beanIterable, String propertyName, K returnCollection) {
        Validate.notBlank(propertyName, "propertyName can't be null/empty!", new Object[0]);
        O o = IterableUtils.get(beanIterable, 0);
        Class<?> klass = o.getClass();
        if (PropertyDescriptorUtil.isUseSpringOperate(klass, propertyName)) {
            PropertyDescriptor propertyDescriptor = PropertyDescriptorUtil.getSpringPropertyDescriptor(klass, propertyName);
            for (O bean : beanIterable) {
                returnCollection.add(PropertyValueObtainer.getValue(bean, propertyDescriptor));
            }
            return returnCollection;
        }
        for (O bean : beanIterable) {
            returnCollection.add(PropertyUtil.getProperty(bean, propertyName));
        }
        return returnCollection;
    }

    public static <T, O> T getValue(O obj, PropertyDescriptor propertyDescriptor) {
        Validate.notNull(obj, "obj can't be null!", new Object[0]);
        Validate.notNull(propertyDescriptor, "propertyDescriptor can't be null!", new Object[0]);
        Method readMethod = propertyDescriptor.getReadMethod();
        Validate.notNull(readMethod, "class:[%s],propertyDescriptor name:[%s],has no ReadMethod!!,pls check", obj.getClass().getCanonicalName(), propertyDescriptor.getDisplayName());
        readMethod = MethodUtils.getAccessibleMethod(obj.getClass(), readMethod);
        try {
            return (T)readMethod.invoke(obj, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DefaultRuntimeException(e);
        }
    }
}

