/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.core;

import com.feilong.core.Validator;
import com.feilong.tools.slf4j.Slf4jUtil;

public class DefaultRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -1699987643831455524L;

    public DefaultRuntimeException(String message) {
        super(message);
    }

    public DefaultRuntimeException(String messagePattern, Object ... args) {
        super(Slf4jUtil.format(messagePattern, args));
    }

    public DefaultRuntimeException(String message, Throwable cause) {
        super(DefaultRuntimeException.buildMessage(message, cause), cause);
    }

    public DefaultRuntimeException(Throwable cause) {
        super(cause);
    }

    private static String buildMessage(String message, Throwable cause) {
        if (Validator.isNullOrEmpty(message)) {
            return DefaultRuntimeException.causeMessage(cause);
        }
        return message + ",cause by:[" + DefaultRuntimeException.causeMessage(cause) + "]";
    }

    private static String causeMessage(Throwable cause) {
        return cause == null ? null : cause.toString();
    }
}

