/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.invoker.http;

import com.feilong.core.Validate;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.json.JsonUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.template.TemplateUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpRequestUriResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestUriResolver.class);

    private HttpRequestUriResolver() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    static <T> String resolve(String uri, T request) {
        Validate.notBlank(uri, "uri can't be blank!", new Object[0]);
        String result = HttpRequestUriResolver.parse(uri, request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parse uri:[{}],request:[{}],result:[{}]", new Object[]{uri, JsonUtil.format(request), result});
        }
        return result;
    }

    private static <T> String parse(String uri, T request) {
        if (uri.contains("%s")) {
            return StringUtil.format(uri, request);
        }
        if (uri.contains("${")) {
            return HttpRequestUriResolver.resolveTemplate(uri, request);
        }
        return uri;
    }

    private static <T> String resolveTemplate(String uri, T request) {
        Validate.notNull(request, "request can't be null!", new Object[0]);
        String attributeName = StringUtils.uncapitalize(request.getClass().getSimpleName());
        Map<String, T> map = ConvertUtil.toMap(attributeName, request);
        String result = TemplateUtil.parseString(uri, map);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parse uri:[{}],use map:[{}],result:[{}]", new Object[]{uri, JsonUtil.formatSimpleMap(map), result});
        }
        return result;
    }
}

