/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.invoker;

import com.feilong.context.InputParamsValidateable;
import com.feilong.context.converter.StringToBeanConverter;
import com.feilong.context.invoker.InvokerRequest;
import com.feilong.context.invoker.InvokerRequestValidator;
import com.feilong.context.invoker.InvokerResponseBlankException;
import com.feilong.context.invoker.InvokerResult;
import com.feilong.context.invoker.InvokerResultConverter;
import com.feilong.context.invoker.RequestResultInvoker;
import com.feilong.context.invoker.ResponseCommand;
import com.feilong.context.invoker.ResponseStringBuilder;
import com.feilong.core.Validator;
import com.feilong.json.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestResultInvoker<T extends ResponseCommand, R extends InvokerRequest, N extends InvokerResult>
implements RequestResultInvoker<R, N>,
InputParamsValidateable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequestResultInvoker.class);
    protected InvokerRequestValidator<R> invokerRequestValidator;
    protected ResponseStringBuilder<R> responseStringBuilder;
    protected StringToBeanConverter<T> stringToBeanConverter;
    protected InvokerResultConverter<R, T, N> invokerResultConverter;

    @Override
    public N invoke(R queryRequest) {
        if (null != this.invokerRequestValidator) {
            this.invokerRequestValidator.validate(queryRequest);
        }
        return this.doHandler(queryRequest);
    }

    public N doHandler(R request) {
        String invokerResponse = this.responseStringBuilder.build(request);
        if (Validator.isNullOrEmpty(invokerResponse)) {
            throw new InvokerResponseBlankException("invokerResponse can't be null/empty!,request:[{}]", JsonUtil.format(request));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("NetpayRequest:[{}],invokerResponse:[{}]", (Object)JsonUtil.format(request), (Object)invokerResponse);
        }
        ResponseCommand t = (ResponseCommand)this.stringToBeanConverter.convert(invokerResponse);
        return this.invokerResultConverter.convert(request, invokerResponse, t);
    }

    public void setInvokerRequestValidator(InvokerRequestValidator<R> invokerRequestValidator) {
        this.invokerRequestValidator = invokerRequestValidator;
    }

    public void setResponseStringBuilder(ResponseStringBuilder<R> responseStringBuilder) {
        this.responseStringBuilder = responseStringBuilder;
    }

    public void setStringToBeanConverter(StringToBeanConverter<T> stringToBeanConverter) {
        this.stringToBeanConverter = stringToBeanConverter;
    }

    public void setInvokerResultConverter(InvokerResultConverter<R, T, N> invokerResultConverter) {
        this.invokerResultConverter = invokerResultConverter;
    }
}

