/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.converter;

import com.feilong.context.converter.StringToBeanConverter;
import com.feilong.core.Validator;
import com.feilong.formatter.FormatterUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStringToBeanConverter<T>
implements StringToBeanConverter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStringToBeanConverter.class);

    @Override
    public T convert(String value) {
        if (Validator.isNullOrEmpty(value)) {
            return null;
        }
        this.preHandlerLog(value);
        this.preHandler(value);
        T t = this.handler(value);
        this.postHandler(t);
        return t;
    }

    private void preHandlerLog(String value) {
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug("input String:[{}],after format:{} {}", new Object[]{value, System.lineSeparator(), this.formatValue(value)});
            }
            catch (Exception e) {
                String message = Slf4jUtil.format("inputString:[{}] can't format,message:[{}]", value, e.getMessage());
                throw new IllegalArgumentException(message, e);
            }
        }
    }

    protected String formatValue(String value) {
        return value;
    }

    protected abstract T handler(String var1);

    protected void preHandler(String inputString) {
    }

    protected void postHandler(T t) {
        if (LOGGER.isDebugEnabled()) {
            String message = "after [{}] convert,return [{}],info :{}";
            LOGGER.debug(message, new Object[]{this.getClass().getSimpleName(), t.getClass().getName(), FormatterUtil.formatToSimpleTable(t)});
        }
    }
}

