/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context.codecreator;

import com.feilong.context.codecreator.CodeCreatorHelper;
import com.feilong.context.codecreator.SequenceTypeOrderCodeCreator;
import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.RandomUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSequenceTypeOrderCodeCreator
implements SequenceTypeOrderCodeCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSequenceTypeOrderCodeCreator.class);
    private boolean isDebug = false;

    public SimpleSequenceTypeOrderCodeCreator() {
    }

    public SimpleSequenceTypeOrderCodeCreator(boolean isDebug) {
        this.isDebug = isDebug;
    }

    @Override
    public String create(long sequence, int maxLength) {
        Validate.isTrue(sequence > 0L, "sequence: [%s] must > 0", sequence);
        Validate.isTrue(maxLength > 0, "maxLength: [%s] must > 0", maxLength);
        int sequenceLength = String.valueOf(sequence).length();
        if (sequenceLength > maxLength) {
            return String.valueOf(sequence);
        }
        Validate.isTrue(maxLength == 11, "maxLength == 11", new Object[0]);
        Date now = DateUtil.now();
        String yyString = DateUtil.toString(now, "yy");
        String hourOfYear = StringUtil.format("%04d", DateUtil.getHourOfYear(now));
        String randomString = "" + RandomUtil.createRandomWithLength(2);
        StringBuilder sb = new StringBuilder();
        if (11 == maxLength) {
            sb.append((CharSequence)this.create11Code(sequence, sequenceLength, yyString, hourOfYear));
        }
        sb.append(CodeCreatorHelper.debugSeparator(this.isDebug) + randomString);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}", (Object)(sb.toString() + CodeCreatorHelper.debugLength(sb, this.isDebug)));
        }
        return sb.toString().replace(" ", "");
    }

    private StringBuilder create11Code(long sequence, int sequenceLength, String yy, String hourOfYear) {
        StringBuilder sb = new StringBuilder();
        if (sequenceLength <= 3) {
            sb.append(CodeCreatorHelper.debugSeparator(this.isDebug) + yy);
            sb.append(CodeCreatorHelper.debugSeparator(this.isDebug) + hourOfYear);
            sb.append(CodeCreatorHelper.debugSeparator(this.isDebug) + StringUtil.format("%03d", sequence));
        } else {
            int vString = Integer.parseInt(yy + hourOfYear) * 1000;
            sb.append(CodeCreatorHelper.debugSeparator(this.isDebug) + ((long)vString + sequence));
        }
        return sb;
    }

    public void setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }
}

