/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.context;

import com.feilong.core.Validate;
import com.feilong.core.lang.reflect.FieldUtil;
import com.feilong.json.JsonUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.util.Map;

public final class BeanLogMessageBuilder {
    private BeanLogMessageBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String buildFieldsMessage(Object obj) {
        Validate.notNull(obj, "obj can't be null!", new Object[0]);
        Map<String, Object> map = FieldUtil.getAllFieldNameAndValueMap(obj, new String[0]);
        return BeanLogMessageBuilder.build(obj, JsonUtil.format(map));
    }

    public static String buildFieldsSimpleMessage(Object obj) {
        Validate.notNull(obj, "obj can't be null!", new Object[0]);
        Map<String, Object> map = FieldUtil.getAllFieldNameAndValueMap(obj, new String[0]);
        return BeanLogMessageBuilder.build(obj, JsonUtil.formatSimpleMap(map));
    }

    private static String build(Object obj, String mapInfo) {
        return Slf4jUtil.format("[{}] field's value map:\n[{}]", obj.getClass().getCanonicalName(), mapInfo);
    }
}

