/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.component.download;

import com.feilong.context.filecreator.RequestFileCreator;
import com.feilong.context.filecreator.RequestFileCreatorDetector;
import com.feilong.core.date.DateUtil;
import com.feilong.servlet.http.ResponseDownloadUtil;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class DownloadController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadController.class);
    private final AtomicInteger counter = new AtomicInteger(0);
    @Autowired
    private RequestFileCreatorDetector requestFileCreatorDetector;

    @RequestMapping(value={"/download"}, method={RequestMethod.GET, RequestMethod.POST})
    public void download(HttpServletRequest request, HttpServletResponse response) {
        Date beginDate = new Date();
        RequestFileCreator requestFileCreator = this.requestFileCreatorDetector.detect(request);
        String filePath = requestFileCreator.create(request);
        Validate.notBlank((CharSequence)filePath, (String)"filePath can't be blank!", (Object[])new Object[0]);
        ResponseDownloadUtil.download(filePath, request, response);
        int incrementAndGet = this.counter.incrementAndGet();
        if (LOGGER.isInfoEnabled()) {
            String pattern = "download times:[{}],requestFileCreator:[{}],use time: [{}]";
            LOGGER.info(pattern, new Object[]{incrementAndGet, requestFileCreator.getClass().getSimpleName(), DateUtil.formatDuration(beginDate)});
        }
    }
}

