/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.accessor.cookie;

import com.feilong.core.CharsetType;
import com.feilong.core.bean.BeanUtil;
import com.feilong.core.net.URIUtil;
import com.feilong.servlet.http.CookieUtil;
import com.feilong.servlet.http.entity.CookieEntity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieAccessor {
    private CookieEntity cookieEntity;
    private boolean isValueEncoding = false;

    public void save(String value, HttpServletResponse response) {
        CookieEntity cloneCookieEntity = BeanUtil.cloneBean(this.cookieEntity);
        String useValue = this.isValueEncoding ? URIUtil.encode(value, CharsetType.UTF8) : value;
        cloneCookieEntity.setValue(useValue);
        CookieUtil.addCookie(cloneCookieEntity, response);
    }

    public String get(HttpServletRequest request) {
        String cookieValue = CookieUtil.getCookieValue(request, this.cookieEntity.getName());
        if (null == cookieValue) {
            return null;
        }
        return this.isValueEncoding ? URIUtil.decode(cookieValue, CharsetType.UTF8) : cookieValue;
    }

    public void remove(HttpServletResponse response) {
        CookieEntity cloneCookieEntity = BeanUtil.cloneBean(this.cookieEntity);
        CookieUtil.deleteCookie(cloneCookieEntity, response);
    }

    public void setCookieEntity(CookieEntity cookieEntity) {
        this.cookieEntity = cookieEntity;
    }

    public void setIsValueEncoding(boolean isValueEncoding) {
        this.isValueEncoding = isValueEncoding;
    }

    public CookieEntity getCookieEntity() {
        return this.cookieEntity;
    }

    public boolean getIsValueEncoding() {
        return this.isValueEncoding;
    }
}

