/*
 * Decompiled with CFR 0.152.
 */
package com.icebuf.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ReflectUtil {
    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClazz) {
        Class<?> superClazz;
        T annotation = clazz.getAnnotation(annotationClazz);
        if (annotation == null && (superClazz = clazz.getSuperclass()) != null) {
            annotation = ReflectUtil.getAnnotation(superClazz, annotationClazz);
        }
        return annotation;
    }

    public static boolean set(@NonNull Object object, @NonNull String fieldName, Object value) {
        return ReflectUtil.set(object, fieldName, value, false);
    }

    public static boolean set(@NonNull Object object, @NonNull String fieldName, Object value, boolean includeSuper) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            return ReflectUtil.set(object, field, value);
        }
        catch (NoSuchFieldException e) {
            return includeSuper && ReflectUtil.setSuperField(object, fieldName, value);
        }
    }

    private static boolean set(@NonNull Object object, Field field, @Nullable Object value) {
        if (field == null) {
            return false;
        }
        ReflectUtil.accessible(field);
        try {
            field.set(object, value);
            return true;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static <T> T get(T t, Field field) {
        if (field == null) {
            return null;
        }
        ReflectUtil.accessible(field);
        try {
            return ReflectUtil.cast(field.get(t));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean getBoolean(Object object, Field field) {
        ReflectUtil.accessible(field);
        try {
            return field.getBoolean(object);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void accessible(AccessibleObject object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
    }

    public static boolean setSuperField(Object object, String fieldName, Object fieldValue) {
        Field field = ReflectUtil.getSuperField(object.getClass(), fieldName);
        return ReflectUtil.set(object, field, fieldValue);
    }

    public static Field getSuperField(Class<?> clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return ReflectUtil.getSuperField(clazz.getSuperclass(), fieldName);
        }
    }

    public static <T> T newInstanceSafe(Class<?> assignableClazz, String clazzName, Object ... objects) {
        try {
            Class clazz = (Class)ReflectUtil.cast(Class.forName(clazzName));
            return ReflectUtil.newInstanceSafe(assignableClazz, clazz, objects);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static <T> T cast(Object obj) {
        if (obj != null) {
            Class<?> clazz = obj.getClass();
            return (T)clazz.cast(obj);
        }
        return null;
    }

    public static <T> T newInstance(String clazzName, Object ... objects) {
        try {
            Class clazz = (Class)ReflectUtil.cast(Class.forName(clazzName));
            return ReflectUtil.newInstance(clazz, objects);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static <T> T newInstanceSafe(Class<?> assignableClazz, Class<T> clazz, Object ... objects) {
        if (assignableClazz.isAssignableFrom(clazz)) {
            return ReflectUtil.newInstance(clazz, objects);
        }
        throw new RuntimeException("the param class of " + clazz.getName() + " must be assignable from " + assignableClazz.getName());
    }

    public static <T> T newInstance(Class<T> clazz, Object ... objects) {
        try {
            if (objects == null || objects.length <= 0) {
                return clazz.newInstance();
            }
            ArrayList clazzList = new ArrayList();
            for (Object object : objects) {
                clazzList.add(object.getClass());
            }
            Constructor<T> constructor = clazz.getConstructor(clazzList.toArray(new Class[0]));
            return clazz.cast(constructor.newInstance(objects));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void invoke(Object object, String name, Object ... params) {
        Class<?> clazz = object.getClass();
        Class[] paramsClazz = null;
        if (params != null) {
            paramsClazz = new Class[params.length];
            for (int i = 0; i < paramsClazz.length; ++i) {
                paramsClazz[i] = params[i].getClass();
            }
        }
        try {
            Method method = clazz.getDeclaredMethod(name, paramsClazz);
            method.invoke(object, params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

