/*
 * Decompiled with CFR 0.152.
 */
package com.icebuf.util;

import android.graphics.Bitmap;
import android.util.Log;
import androidx.annotation.NonNull;
import com.icebuf.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class BitmapUtil {
    private static final String TAG = BitmapUtil.class.getSimpleName();

    private BitmapUtil() {
    }

    public static void compress2Jpeg(Bitmap bitmap, String path, int quality) throws IOException {
        BitmapUtil.compress2Jpeg(bitmap, new File(path), quality);
    }

    public static String compress2Jpeg(Bitmap bitmap, String path, String name, int quality) throws IOException {
        return BitmapUtil.compress(bitmap, Bitmap.CompressFormat.JPEG, path, name, quality);
    }

    public static String compress2Png(Bitmap bitmap, String path, String name) throws IOException {
        return BitmapUtil.compress(bitmap, Bitmap.CompressFormat.PNG, path, name, 100);
    }

    public static String compress(@NonNull Bitmap bitmap, Bitmap.CompressFormat format, String path, String name, int quality) throws IOException {
        String fileName = name.toLowerCase();
        switch (format) {
            case PNG: {
                fileName = FileUtil.getNameWithExtension(fileName, ".png");
                break;
            }
            case JPEG: {
                String reg = ".(jp[e]?g)$";
                if (Pattern.matches(reg, fileName)) break;
                fileName = FileUtil.getNameWithExtension(fileName, ".jpg");
                break;
            }
            case WEBP: 
            case WEBP_LOSSY: 
            case WEBP_LOSSLESS: {
                fileName = FileUtil.getNameWithExtension(fileName, ".webp");
                break;
            }
            default: {
                throw new IOException("Unsupported compress format!");
            }
        }
        File pathFile = new File(path, fileName);
        BitmapUtil.compress(bitmap, format, new File(pathFile, fileName), quality);
        return pathFile.getPath();
    }

    public static void compress2Jpeg(Bitmap bitmap, File file, int quality) throws IOException {
        BitmapUtil.compress(bitmap, Bitmap.CompressFormat.JPEG, file, quality);
    }

    public static void compress2Png(Bitmap bitmap, File file) throws IOException {
        BitmapUtil.compress(bitmap, Bitmap.CompressFormat.PNG, file, 100);
    }

    public static void compress(@NonNull Bitmap bitmap, Bitmap.CompressFormat format, @NonNull File file, int quality) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("directory " + parent.getPath() + " create failed!");
        }
        if (file.isDirectory() && !file.delete()) {
            throw new IOException("directory " + file.getPath() + " delete failed!");
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("file " + file.getPath() + " create failed!");
        }
        FileOutputStream out = new FileOutputStream(file);
        if (!bitmap.compress(format, quality, (OutputStream)out)) {
            out.close();
            throw new IOException("file " + file.getPath() + " compressed to the specified stream failed!");
        }
        out.flush();
        out.close();
        Log.d((String)TAG, (String)("write file " + file.getName() + " length " + FileUtil.readableFileSize(file.length())));
    }
}

