/*
 * Decompiled with CFR 0.152.
 */
package com.icapps.tools.aec.internal;

import com.icapps.tools.aec.internal.TelnetInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0006\u0010\r\u001a\u00020\u0011J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0006\u0010\u0016\u001a\u00020\u0005J\u0018\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/icapps/tools/aec/internal/ControlChannel;", "", "port", "", "authToken", "", "echoDevice", "", "(ILjava/lang/String;Z)V", "communicationClient", "Ljava/net/Socket;", "inputChannel", "Ljava/io/InputStream;", "open", "outputChannel", "Ljava/io/OutputStream;", "close", "", "closeChannel", "consumeInitialData", "doAuth", "openChannel", "read", "trueSkip", "echo", "write", "data", "Companion", "android-emulator-control"})
public final class ControlChannel {
    private InputStream inputChannel;
    private OutputStream outputChannel;
    private Socket communicationClient;
    private boolean open;
    private final int port;
    private final String authToken;
    private final boolean echoDevice;
    private static final int NO_MORE_DATA_TIMEOUT = 8000;
    public static final Companion Companion = new Companion(null);

    public final void open() {
        if (this.open) {
            throw (Throwable)new IllegalStateException("Channel is already open");
        }
        this.openChannel();
        this.open = true;
    }

    public final void close() {
        if (!this.open) {
            return;
        }
        this.closeChannel();
        this.open = false;
    }

    private final void closeChannel() {
        try {
            this.write("quit");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Socket socket = this.communicationClient;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"communicationClient");
        }
        socket.close();
    }

    private final void openChannel() {
        Socket socket = this.communicationClient = new Socket(InetAddress.getLoopbackAddress(), this.port);
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"communicationClient");
        }
        socket.setSoTimeout(ControlChannel.Companion.getNO_MORE_DATA_TIMEOUT());
        Socket socket2 = this.communicationClient;
        if (socket2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"communicationClient");
        }
        InputStream inputStream = socket2.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"communicationClient.inputStream");
        this.inputChannel = new TelnetInputStream(inputStream);
        Socket socket3 = this.communicationClient;
        if (socket3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"communicationClient");
        }
        OutputStream outputStream = socket3.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"communicationClient.outputStream");
        this.outputChannel = outputStream;
        this.consumeInitialData();
    }

    public final void write(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        OutputStream outputStream = this.outputChannel;
        if (outputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputChannel");
        }
        String string = data;
        Charset charset = Charsets.US_ASCII;
        OutputStream outputStream2 = outputStream;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        outputStream2.write(byArray2);
        OutputStream outputStream3 = this.outputChannel;
        if (outputStream3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputChannel");
        }
        outputStream3.flush();
        OutputStream outputStream4 = this.outputChannel;
        if (outputStream4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputChannel");
        }
        outputStream4.write(13);
        OutputStream outputStream5 = this.outputChannel;
        if (outputStream5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputChannel");
        }
        outputStream5.write(10);
        OutputStream outputStream6 = this.outputChannel;
        if (outputStream6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputChannel");
        }
        outputStream6.flush();
        if (this.echoDevice) {
            int echo = 4 * (data.length() * (data.length() + 1) / 2) + 2;
            InputStream inputStream = this.inputChannel;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputChannel");
            }
            this.trueSkip(inputStream, echo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int trueSkip(InputStream inputChannel, int echo) {
        int n = 1;
        int n2 = echo;
        if (n <= n2) {
            while (true) {
                void i;
                inputChannel.read();
                if (i == n2) break;
                ++i;
            }
        }
        return echo;
    }

    @NotNull
    public final String read() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            InputStream inputStream = this.inputChannel;
            if (inputStream == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inputChannel");
            }
            if ((n = inputStream.read()) == -1) break;
            if (n == 13) {
                InputStream inputStream2 = this.inputChannel;
                if (inputStream2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"inputChannel");
                }
                inputStream2.read();
                break;
            }
            stringBuilder.append((char)n);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"stringBuilder.toString()");
        String string3 = string = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    /*
     * Exception decompiling
     */
    private final void consumeInitialData() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doAuth() {
        String offendingLine;
        boolean authOk;
        block3: {
            this.write("auth " + this.authToken);
            authOk = false;
            offendingLine = null;
            try {
                String line;
                do {
                    Regex regex = new Regex("NOK.*");
                    line = this.read();
                    CharSequence charSequence = line;
                    if (!regex.matches(charSequence)) continue;
                    offendingLine = line;
                    break block3;
                } while (!Intrinsics.areEqual((Object)line, (Object)"OK"));
                return;
            }
            catch (SocketTimeoutException e) {}
        }
        if (authOk) return;
        throw (Throwable)new IOException("Failed to authenticate: " + offendingLine);
    }

    public ControlChannel(int port, @NotNull String authToken, boolean echoDevice) {
        Intrinsics.checkParameterIsNotNull((Object)authToken, (String)"authToken");
        this.port = port;
        this.authToken = authToken;
        this.echoDevice = echoDevice;
    }

    static {
        NO_MORE_DATA_TIMEOUT = 8000;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/icapps/tools/aec/internal/ControlChannel$Companion;", "", "()V", "NO_MORE_DATA_TIMEOUT", "", "getNO_MORE_DATA_TIMEOUT", "()I", "android-emulator-control"})
    public static final class Companion {
        private final int getNO_MORE_DATA_TIMEOUT() {
            return NO_MORE_DATA_TIMEOUT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

