/*
 * Decompiled with CFR 0.152.
 */
package com.icapps.tools.aec.control;

import com.icapps.tools.aec.PowerConfiguration;
import com.icapps.tools.aec.PowerControl;
import com.icapps.tools.aec.PowerHealthStatus;
import com.icapps.tools.aec.PowerStatus;
import com.icapps.tools.aec.internal.ControlChannel;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/icapps/tools/aec/control/PowerControlImpl;", "Lcom/icapps/tools/aec/PowerControl;", "controlChannel", "Lcom/icapps/tools/aec/internal/ControlChannel;", "(Lcom/icapps/tools/aec/internal/ControlChannel;)V", "powerConfig", "Lcom/icapps/tools/aec/PowerConfiguration;", "setAcStatus", "", "isConnected", "setBattery", "hasBattery", "setCapacity", "capacity", "", "setPowerHealthStatus", "powerHealthStatus", "Lcom/icapps/tools/aec/PowerHealthStatus;", "setPowerStatus", "powerStatus", "Lcom/icapps/tools/aec/PowerStatus;", "Companion", "android-emulator-control"})
public final class PowerControlImpl
implements PowerControl {
    private final ControlChannel controlChannel;
    private static final Regex powerDisplayRegex;
    public static final Companion Companion;

    @Override
    @NotNull
    public PowerConfiguration powerConfig() {
        String line;
        this.controlChannel.write("power display");
        boolean acStatus = false;
        PowerStatus status = PowerStatus.UNKNOWN;
        PowerHealthStatus health = PowerHealthStatus.UNKNOWN;
        boolean hasBattery = false;
        int capacity = -1;
        while (!Intrinsics.areEqual((Object)(line = this.controlChannel.read()), (Object)"OK") && !StringsKt.startsWith$default((String)line, (String)"KO:", (boolean)false, (int)2, null)) {
            String string;
            String string2;
            MatchResult result;
            if (PowerControlImpl.Companion.getPowerDisplayRegex().matchEntire((CharSequence)line) == null) {
                continue;
            }
            List groups = result.getGroupValues();
            String string3 = string2 = (String)groups.get(1);
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = string2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
            int n = -1;
            switch (string.hashCode()) {
                case 3106: {
                    if (!string.equals("ac")) break;
                    n = 1;
                    break;
                }
                case -1221262756: {
                    if (!string.equals("health")) break;
                    n = 2;
                    break;
                }
                case -318277445: {
                    if (!string.equals("present")) break;
                    n = 3;
                    break;
                }
                case -892481550: {
                    if (!string.equals("status")) break;
                    n = 4;
                    break;
                }
                case -67824454: {
                    if (!string.equals("capacity")) break;
                    n = 5;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    acStatus = Intrinsics.areEqual((Object)((String)groups.get(2)), (Object)"online");
                    break;
                }
                case 4: {
                    String string5 = string2 = (String)groups.get(2);
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toUpperCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
                    status = PowerStatus.valueOf(string6);
                    break;
                }
                case 2: {
                    String string7 = string2 = (String)groups.get(2);
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.toUpperCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toUpperCase()");
                    health = PowerHealthStatus.valueOf(string8);
                    break;
                }
                case 3: {
                    hasBattery = Intrinsics.areEqual((Object)((String)groups.get(2)), (Object)"true");
                    break;
                }
                case 5: {
                    string2 = (String)groups.get(2);
                    capacity = Integer.parseInt(string2);
                }
            }
        }
        return new PowerConfiguration(acStatus, status, health, hasBattery, capacity);
    }

    @Override
    public boolean setAcStatus(boolean isConnected) {
        this.controlChannel.write("power ac " + (isConnected ? "on" : "off"));
        return Intrinsics.areEqual((Object)this.controlChannel.read(), (Object)"OK");
    }

    @Override
    public boolean setPowerStatus(@NotNull PowerStatus powerStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)powerStatus), (String)"powerStatus");
        String string = powerStatus.name();
        StringBuilder stringBuilder = new StringBuilder().append("power status ");
        ControlChannel controlChannel = this.controlChannel;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        controlChannel.write(stringBuilder.append(string4).toString());
        return Intrinsics.areEqual((Object)this.controlChannel.read(), (Object)"OK");
    }

    @Override
    public boolean setPowerHealthStatus(@NotNull PowerHealthStatus powerHealthStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)powerHealthStatus), (String)"powerHealthStatus");
        String string = powerHealthStatus.name();
        StringBuilder stringBuilder = new StringBuilder().append("power health ");
        ControlChannel controlChannel = this.controlChannel;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        controlChannel.write(stringBuilder.append(string4).toString());
        return Intrinsics.areEqual((Object)this.controlChannel.read(), (Object)"OK");
    }

    @Override
    public boolean setBattery(boolean hasBattery) {
        this.controlChannel.write("power present " + (hasBattery ? "true" : "false"));
        return Intrinsics.areEqual((Object)this.controlChannel.read(), (Object)"OK");
    }

    @Override
    public boolean setCapacity(int capacity) {
        this.controlChannel.write("power capacity " + capacity);
        return Intrinsics.areEqual((Object)this.controlChannel.read(), (Object)"OK");
    }

    public PowerControlImpl(@NotNull ControlChannel controlChannel) {
        Intrinsics.checkParameterIsNotNull((Object)controlChannel, (String)"controlChannel");
        this.controlChannel = controlChannel;
    }

    static {
        Companion = new Companion(null);
        powerDisplayRegex = new Regex("([^:]+):\\s*(.*)");
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/icapps/tools/aec/control/PowerControlImpl$Companion;", "", "()V", "powerDisplayRegex", "Lkotlin/text/Regex;", "getPowerDisplayRegex", "()Lkotlin/text/Regex;", "android-emulator-control"})
    public static final class Companion {
        private final Regex getPowerDisplayRegex() {
            return powerDisplayRegex;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

