/*
 * Decompiled with CFR 0.152.
 */
package me.ibrahimsn.lib;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.FontRes;
import androidx.annotation.XmlRes;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.navigation.NavController;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ibrahimsn.lib.AccessibleExploreByTouchHelper;
import me.ibrahimsn.lib.BottomBarItem;
import me.ibrahimsn.lib.BottomBarParser;
import me.ibrahimsn.lib.NavigationComponentHelper;
import me.ibrahimsn.lib.OnItemReselectedListener;
import me.ibrahimsn.lib.OnItemSelectedListener;
import me.ibrahimsn.lib.R;
import me.ibrahimsn.lib.ext.ContextExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0095\u00012\u00020\u0001:\u0002\u0095\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010v\u001a\u00020\\2\u0006\u0010w\u001a\u00020Y2\u0006\u0010x\u001a\u00020\u0007H\u0002J\b\u0010y\u001a\u00020\\H\u0002J\u0010\u0010z\u001a\u00020{2\u0006\u0010|\u001a\u00020}H\u0014J\u001a\u0010~\u001a\u00020\\2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0011\u0010\u007f\u001a\u00020\\2\u0007\u0010\u0080\u0001\u001a\u00020\u0007H\u0002J\u0013\u0010\u0081\u0001\u001a\u00020\\2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0014J-\u0010\u0084\u0001\u001a\u00020\\2\u0007\u0010\u0085\u0001\u001a\u00020\u00072\u0007\u0010\u0086\u0001\u001a\u00020\u00072\u0007\u0010\u0087\u0001\u001a\u00020\u00072\u0007\u0010\u0088\u0001\u001a\u00020\u0007H\u0014J\u0013\u0010\u0089\u0001\u001a\u00020{2\b\u0010|\u001a\u0004\u0018\u00010}H\u0017J-\u0010e\u001a\u00020\\2%\u0010\u008a\u0001\u001a \u0012\u0016\u0012\u00140\u0007\u00a2\u0006\u000f\b\u008b\u0001\u0012\n\b\u008c\u0001\u0012\u0005\b\b(\u008d\u0001\u0012\u0004\u0012\u00020\\0[J-\u0010n\u001a\u00020\\2%\u0010\u008a\u0001\u001a \u0012\u0016\u0012\u00140\u0007\u00a2\u0006\u000f\b\u008b\u0001\u0012\n\b\u008c\u0001\u0012\u0005\b\b(\u008d\u0001\u0012\u0004\u0012\u00020\\0[J\u001b\u0010\u008e\u0001\u001a\u00020\\2\b\u0010\u008f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0091\u0001\u001a\u00030\u0092\u0001J$\u0010\u0093\u0001\u001a\u00020\\2\u0006\u0010w\u001a\u00020Y2\u0007\u0010\u0094\u0001\u001a\u00020\u00072\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002R\u0012\u0010\t\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001c\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R&\u0010!\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u000b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R&\u0010&\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u001e\"\u0004\b(\u0010 R&\u0010)\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u000b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R&\u0010,\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u000b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010#\"\u0004\b.\u0010%R\u000e\u0010/\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00103\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010\u001e\"\u0004\b5\u0010 R$\u00106\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R&\u0010;\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b<\u0010\u001e\"\u0004\b=\u0010 R&\u0010>\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u000b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010#\"\u0004\b@\u0010%R&\u0010A\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u000b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010#\"\u0004\bC\u0010%R&\u0010D\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010\u001e\"\u0004\bF\u0010 R&\u0010G\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010\u001e\"\u0004\bI\u0010 R&\u0010J\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010\u001e\"\u0004\bL\u0010 R&\u0010M\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u000b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010#\"\u0004\bO\u0010%R&\u0010P\u001a\u00020\u00072\b\b\u0001\u0010\u001b\u001a\u00020\u00078G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bQ\u0010\u001e\"\u0004\bR\u0010 R&\u0010S\u001a\u00020\u000b2\b\b\u0001\u0010\u001b\u001a\u00020\u000b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010#\"\u0004\bU\u0010%R\u000e\u0010V\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0XX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010Z\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\\\u0018\u00010[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010^\"\u0004\b_\u0010`R\u001c\u0010a\u001a\u0004\u0018\u00010bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR(\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\\\u0018\u00010[X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010^\"\u0004\bi\u0010`R\u001c\u0010j\u001a\u0004\u0018\u00010kX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u000e\u0010p\u001a\u00020qX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010r\u001a\u00020qX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010s\u001a\u00020qX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020uX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0096\u0001"}, d2={"Lme/ibrahimsn/lib/SmoothBottomBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "_barBackgroundColor", "_barCornerRadius", "", "_barIndicatorColor", "_barIndicatorRadius", "_barSideMargins", "_itemActiveIndex", "_itemAnimDuration", "", "_itemFontFamily", "_itemIconMargin", "_itemIconSize", "_itemIconTint", "_itemIconTintActive", "_itemMenuRes", "_itemPadding", "_itemTextColor", "_itemTextSize", "value", "barBackgroundColor", "getBarBackgroundColor", "()I", "setBarBackgroundColor", "(I)V", "barCornerRadius", "getBarCornerRadius", "()F", "setBarCornerRadius", "(F)V", "barIndicatorColor", "getBarIndicatorColor", "setBarIndicatorColor", "barIndicatorRadius", "getBarIndicatorRadius", "setBarIndicatorRadius", "barSideMargins", "getBarSideMargins", "setBarSideMargins", "currentIconTint", "exploreByTouchHelper", "Lme/ibrahimsn/lib/AccessibleExploreByTouchHelper;", "indicatorLocation", "itemActiveIndex", "getItemActiveIndex", "setItemActiveIndex", "itemAnimDuration", "getItemAnimDuration", "()J", "setItemAnimDuration", "(J)V", "itemFontFamily", "getItemFontFamily", "setItemFontFamily", "itemIconMargin", "getItemIconMargin", "setItemIconMargin", "itemIconSize", "getItemIconSize", "setItemIconSize", "itemIconTint", "getItemIconTint", "setItemIconTint", "itemIconTintActive", "getItemIconTintActive", "setItemIconTintActive", "itemMenuRes", "getItemMenuRes", "setItemMenuRes", "itemPadding", "getItemPadding", "setItemPadding", "itemTextColor", "getItemTextColor", "setItemTextColor", "itemTextSize", "getItemTextSize", "setItemTextSize", "itemWidth", "items", "", "Lme/ibrahimsn/lib/BottomBarItem;", "onItemReselected", "Lkotlin/Function1;", "", "getOnItemReselected", "()Lkotlin/jvm/functions/Function1;", "setOnItemReselected", "(Lkotlin/jvm/functions/Function1;)V", "onItemReselectedListener", "Lme/ibrahimsn/lib/OnItemReselectedListener;", "getOnItemReselectedListener", "()Lme/ibrahimsn/lib/OnItemReselectedListener;", "setOnItemReselectedListener", "(Lme/ibrahimsn/lib/OnItemReselectedListener;)V", "onItemSelected", "getOnItemSelected", "setOnItemSelected", "onItemSelectedListener", "Lme/ibrahimsn/lib/OnItemSelectedListener;", "getOnItemSelectedListener", "()Lme/ibrahimsn/lib/OnItemSelectedListener;", "setOnItemSelectedListener", "(Lme/ibrahimsn/lib/OnItemSelectedListener;)V", "paintBackground", "Landroid/graphics/Paint;", "paintIndicator", "paintText", "rect", "Landroid/graphics/RectF;", "animateAlpha", "item", "to", "applyItemActiveIndex", "dispatchHoverEvent", "", "event", "Landroid/view/MotionEvent;", "obtainStyledAttributes", "onClickAction", "viewId", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "listener", "Lkotlin/ParameterName;", "name", "position", "setupWithNavController", "menu", "Landroid/view/Menu;", "navController", "Landroidx/navigation/NavController;", "tintAndDrawIcon", "index", "Companion", "lib_release"})
public final class SmoothBottomBar
extends View {
    private float itemWidth;
    private int currentIconTint;
    private float indicatorLocation;
    private final RectF rect;
    private List<BottomBarItem> items;
    @ColorInt
    private int _barBackgroundColor;
    @ColorInt
    private int _barIndicatorColor;
    @Dimension
    private float _barIndicatorRadius;
    @Dimension
    private float _barSideMargins;
    @Dimension
    private float _barCornerRadius;
    @Dimension
    private float _itemPadding;
    private long _itemAnimDuration;
    @Dimension
    private float _itemIconSize;
    @Dimension
    private float _itemIconMargin;
    @ColorInt
    private int _itemIconTint;
    @ColorInt
    private int _itemIconTintActive;
    @ColorInt
    private int _itemTextColor;
    @Dimension
    private float _itemTextSize;
    @FontRes
    private int _itemFontFamily;
    @XmlRes
    private int _itemMenuRes;
    private int _itemActiveIndex;
    @Nullable
    private OnItemSelectedListener onItemSelectedListener;
    @Nullable
    private OnItemReselectedListener onItemReselectedListener;
    @Nullable
    private Function1<? super Integer, Unit> onItemSelected;
    @Nullable
    private Function1<? super Integer, Unit> onItemReselected;
    private final Paint paintBackground;
    private final Paint paintIndicator;
    private final Paint paintText;
    private AccessibleExploreByTouchHelper exploreByTouchHelper;
    private static final int INVALID_RES = -1;
    private static final String DEFAULT_INDICATOR_COLOR = "#2DFFFFFF";
    private static final String DEFAULT_TINT = "#C8FFFFFF";
    private static final float DEFAULT_SIDE_MARGIN = 10.0f;
    private static final float DEFAULT_ITEM_PADDING = 10.0f;
    private static final long DEFAULT_ANIM_DURATION = 200L;
    private static final float DEFAULT_ICON_SIZE = 18.0f;
    private static final float DEFAULT_ICON_MARGIN = 4.0f;
    private static final float DEFAULT_TEXT_SIZE = 11.0f;
    private static final float DEFAULT_CORNER_RADIUS = 20.0f;
    private static final float DEFAULT_BAR_CORNER_RADIUS = 0.0f;
    private static final int OPAQUE = 255;
    private static final int TRANSPARENT = 0;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @ColorInt
    public final int getBarBackgroundColor() {
        return this._barBackgroundColor;
    }

    public final void setBarBackgroundColor(@ColorInt int value) {
        this._barBackgroundColor = value;
        this.paintBackground.setColor(value);
        this.invalidate();
    }

    @ColorInt
    public final int getBarIndicatorColor() {
        return this._barIndicatorColor;
    }

    public final void setBarIndicatorColor(@ColorInt int value) {
        this._barIndicatorColor = value;
        this.paintIndicator.setColor(value);
        this.invalidate();
    }

    @Dimension
    public final float getBarIndicatorRadius() {
        return this._barIndicatorRadius;
    }

    public final void setBarIndicatorRadius(@Dimension float value) {
        this._barIndicatorRadius = value;
        this.invalidate();
    }

    @Dimension
    public final float getBarSideMargins() {
        return this._barSideMargins;
    }

    public final void setBarSideMargins(@Dimension float value) {
        this._barSideMargins = value;
        this.invalidate();
    }

    @Dimension
    public final float getBarCornerRadius() {
        return this._barCornerRadius;
    }

    public final void setBarCornerRadius(@Dimension float value) {
        this._barCornerRadius = value;
        this.invalidate();
    }

    @Dimension
    public final float getItemTextSize() {
        return this._itemTextSize;
    }

    public final void setItemTextSize(@Dimension float value) {
        this._itemTextSize = value;
        this.paintText.setTextSize(value);
        this.invalidate();
    }

    @ColorInt
    public final int getItemTextColor() {
        return this._itemTextColor;
    }

    public final void setItemTextColor(@ColorInt int value) {
        this._itemTextColor = value;
        this.paintText.setColor(value);
        this.invalidate();
    }

    @Dimension
    public final float getItemPadding() {
        return this._itemPadding;
    }

    public final void setItemPadding(@Dimension float value) {
        this._itemPadding = value;
        this.invalidate();
    }

    public final long getItemAnimDuration() {
        return this._itemAnimDuration;
    }

    public final void setItemAnimDuration(long value) {
        this._itemAnimDuration = value;
    }

    @Dimension
    public final float getItemIconSize() {
        return this._itemIconSize;
    }

    public final void setItemIconSize(@Dimension float value) {
        this._itemIconSize = value;
        this.invalidate();
    }

    @Dimension
    public final float getItemIconMargin() {
        return this._itemIconMargin;
    }

    public final void setItemIconMargin(@Dimension float value) {
        this._itemIconMargin = value;
        this.invalidate();
    }

    @ColorInt
    public final int getItemIconTint() {
        return this._itemIconTint;
    }

    public final void setItemIconTint(@ColorInt int value) {
        this._itemIconTint = value;
        this.invalidate();
    }

    @ColorInt
    public final int getItemIconTintActive() {
        return this._itemIconTintActive;
    }

    public final void setItemIconTintActive(@ColorInt int value) {
        this._itemIconTintActive = value;
        this.invalidate();
    }

    @FontRes
    public final int getItemFontFamily() {
        return this._itemFontFamily;
    }

    public final void setItemFontFamily(@FontRes int value) {
        this._itemFontFamily = value;
        if (value != -1) {
            this.paintText.setTypeface(ResourcesCompat.getFont((Context)this.getContext(), (int)value));
            this.invalidate();
        }
    }

    @XmlRes
    public final int getItemMenuRes() {
        return this._itemMenuRes;
    }

    public final void setItemMenuRes(@XmlRes int value) {
        this._itemMenuRes = value;
        if (value != -1) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.items = new BottomBarParser(context, value).parse();
            this.invalidate();
        }
    }

    public final int getItemActiveIndex() {
        return this._itemActiveIndex;
    }

    public final void setItemActiveIndex(int value) {
        this._itemActiveIndex = value;
        this.applyItemActiveIndex();
    }

    @Nullable
    public final OnItemSelectedListener getOnItemSelectedListener() {
        return this.onItemSelectedListener;
    }

    public final void setOnItemSelectedListener(@Nullable OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    @Nullable
    public final OnItemReselectedListener getOnItemReselectedListener() {
        return this.onItemReselectedListener;
    }

    public final void setOnItemReselectedListener(@Nullable OnItemReselectedListener onItemReselectedListener) {
        this.onItemReselectedListener = onItemReselectedListener;
    }

    @Nullable
    public final Function1<Integer, Unit> getOnItemSelected() {
        return this.onItemSelected;
    }

    public final void setOnItemSelected(@Nullable Function1<? super Integer, Unit> function1) {
        this.onItemSelected = function1;
    }

    @Nullable
    public final Function1<Integer, Unit> getOnItemReselected() {
        return this.onItemReselected;
    }

    public final void setOnItemReselected(@Nullable Function1<? super Integer, Unit> function1) {
        this.onItemReselected = function1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void obtainStyledAttributes(AttributeSet attrs, int defStyleAttr) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SmoothBottomBar, defStyleAttr, 0);
        try {
            this.setBarBackgroundColor(typedArray.getColor(R.styleable.SmoothBottomBar_backgroundColor, this.getBarBackgroundColor()));
            this.setBarIndicatorColor(typedArray.getColor(R.styleable.SmoothBottomBar_indicatorColor, this.getBarIndicatorColor()));
            this.setBarIndicatorRadius(typedArray.getDimension(R.styleable.SmoothBottomBar_indicatorRadius, this.getBarIndicatorRadius()));
            this.setBarSideMargins(typedArray.getDimension(R.styleable.SmoothBottomBar_sideMargins, this.getBarSideMargins()));
            this.setBarCornerRadius(typedArray.getDimension(R.styleable.SmoothBottomBar_cornerRadius, this.getBarCornerRadius()));
            this.setItemPadding(typedArray.getDimension(R.styleable.SmoothBottomBar_itemPadding, this.getItemPadding()));
            this.setItemTextColor(typedArray.getColor(R.styleable.SmoothBottomBar_textColor, this.getItemTextColor()));
            this.setItemTextSize(typedArray.getDimension(R.styleable.SmoothBottomBar_textSize, this.getItemTextSize()));
            this.setItemIconSize(typedArray.getDimension(R.styleable.SmoothBottomBar_iconSize, this.getItemIconSize()));
            this.setItemIconMargin(typedArray.getDimension(R.styleable.SmoothBottomBar_iconMargin, this.getItemIconMargin()));
            this.setItemIconTint(typedArray.getColor(R.styleable.SmoothBottomBar_iconTint, this.getItemIconTint()));
            this.setItemIconTintActive(typedArray.getColor(R.styleable.SmoothBottomBar_iconTintActive, this.getItemIconTintActive()));
            this.setItemActiveIndex(typedArray.getInt(R.styleable.SmoothBottomBar_activeItem, this.getItemActiveIndex()));
            this.setItemFontFamily(typedArray.getResourceId(R.styleable.SmoothBottomBar_itemFontFamily, this.getItemFontFamily()));
            this.setItemAnimDuration(typedArray.getInt(R.styleable.SmoothBottomBar_duration, (int)this.getItemAnimDuration()));
            this.setItemMenuRes(typedArray.getResourceId(R.styleable.SmoothBottomBar_menu, this.getItemMenuRes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float lastX = this.getBarSideMargins();
        this.itemWidth = ((float)this.getWidth() - this.getBarSideMargins() * (float)2) / (float)this.items.size();
        List itemsToLayout = Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1 ? CollectionsKt.reversed((Iterable)this.items) : this.items;
        for (BottomBarItem item : itemsToLayout) {
            boolean shorted = false;
            while (this.paintText.measureText(item.getTitle()) > this.itemWidth - this.getItemIconSize() - this.getItemIconMargin() - this.getItemPadding() * (float)2) {
                item.setTitle(StringsKt.dropLast((String)item.getTitle(), (int)1));
                shorted = true;
            }
            if (shorted) {
                item.setTitle(StringsKt.dropLast((String)item.getTitle(), (int)1));
                BottomBarItem bottomBarItem = item;
                bottomBarItem.setTitle(bottomBarItem.getTitle() + this.getContext().getString(R.string.ellipsis));
            }
            item.setRect(new RectF(lastX, 0.0f, this.itemWidth + lastX, (float)this.getHeight()));
            lastX += this.itemWidth;
        }
        this.applyItemActiveIndex();
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.getBarCornerRadius() > 0.0f && Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.getBarCornerRadius(), this.getBarCornerRadius(), this.paintBackground);
        } else {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paintBackground);
        }
        this.rect.left = this.indicatorLocation;
        this.rect.top = this.items.get(this.getItemActiveIndex()).getRect().centerY() - this.getItemIconSize() / (float)2 - this.getItemPadding();
        this.rect.right = this.indicatorLocation + this.itemWidth;
        this.rect.bottom = this.items.get(this.getItemActiveIndex()).getRect().centerY() + this.getItemIconSize() / (float)2 + this.getItemPadding();
        canvas.drawRoundRect(this.rect, this.getBarIndicatorRadius(), this.getBarIndicatorRadius(), this.paintIndicator);
        float textHeight = (this.paintText.descent() + this.paintText.ascent()) / (float)2;
        if (Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1) {
            boolean bl = false;
            for (BottomBarItem item : (Iterable)this.items) {
                void index;
                float textLength = this.paintText.measureText(item.getTitle());
                item.getIcon().mutate();
                item.getIcon().setBounds((int)item.getRect().centerX() - (int)this.getItemIconSize() / 2 + (int)(textLength / (float)2 * (1.0f - (float)(255 - item.getAlpha()) / (float)255)), this.getHeight() / 2 - (int)this.getItemIconSize() / 2, (int)item.getRect().centerX() + (int)this.getItemIconSize() / 2 + (int)(textLength / (float)2 * (1.0f - (float)(255 - item.getAlpha()) / (float)255)), this.getHeight() / 2 + (int)this.getItemIconSize() / 2);
                this.tintAndDrawIcon(item, (int)index, canvas);
                this.paintText.setAlpha(item.getAlpha());
                canvas.drawText(item.getTitle(), item.getRect().centerX() - (this.getItemIconSize() / (float)2 + this.getItemIconMargin()), item.getRect().centerY() - textHeight, this.paintText);
                ++index;
            }
        } else {
            int index = 0;
            for (BottomBarItem item : (Iterable)this.items) {
                float textLength = this.paintText.measureText(item.getTitle());
                item.getIcon().mutate();
                item.getIcon().setBounds((int)item.getRect().centerX() - (int)this.getItemIconSize() / 2 - (int)(textLength / (float)2 * (1.0f - (float)(255 - item.getAlpha()) / (float)255)), this.getHeight() / 2 - (int)this.getItemIconSize() / 2, (int)item.getRect().centerX() + (int)this.getItemIconSize() / 2 - (int)(textLength / (float)2 * (1.0f - (float)(255 - item.getAlpha()) / (float)255)), this.getHeight() / 2 + (int)this.getItemIconSize() / 2);
                this.tintAndDrawIcon(item, index, canvas);
                this.paintText.setAlpha(item.getAlpha());
                canvas.drawText(item.getTitle(), item.getRect().centerX() + this.getItemIconSize() / (float)2 + this.getItemIconMargin(), item.getRect().centerY() - textHeight, this.paintText);
                ++index;
            }
        }
    }

    private final void tintAndDrawIcon(BottomBarItem item, int index, Canvas canvas) {
        DrawableCompat.setTint((Drawable)item.getIcon(), (int)(index == this.getItemActiveIndex() ? this.currentIconTint : this.getItemIconTint()));
        item.getIcon().draw(canvas);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@Nullable MotionEvent event) {
        Integer n;
        MotionEvent motionEvent = event;
        Integer n2 = n = motionEvent != null ? Integer.valueOf(motionEvent.getAction()) : null;
        int n3 = 0;
        if (n2 != null && n2 == 0) {
            return true;
        }
        Integer n4 = n;
        n3 = 1;
        if (n4 != null && n4 == n3) {
            n3 = 0;
            for (BottomBarItem item : (Iterable)this.items) {
                void i;
                if (item.getRect().contains(event.getX(), event.getY())) {
                    this.onClickAction((int)i);
                    break;
                }
                ++i;
            }
        }
        return super.onTouchEvent(event);
    }

    protected boolean dispatchHoverEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.exploreByTouchHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    private final void onClickAction(int viewId) {
        this.exploreByTouchHelper.invalidateVirtualView(viewId);
        if (viewId != this.getItemActiveIndex()) {
            this.setItemActiveIndex(viewId);
            Function1<? super Integer, Unit> function1 = this.onItemSelected;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)viewId);
            }
            OnItemSelectedListener onItemSelectedListener = this.onItemSelectedListener;
            if (onItemSelectedListener != null) {
                onItemSelectedListener.onItemSelect(viewId);
            }
        } else {
            Function1<? super Integer, Unit> function1 = this.onItemReselected;
            if (function1 != null) {
                Unit cfr_ignored_1 = (Unit)function1.invoke((Object)viewId);
            }
            OnItemReselectedListener onItemReselectedListener = this.onItemReselectedListener;
            if (onItemReselectedListener != null) {
                onItemReselectedListener.onItemReselect(viewId);
            }
        }
        this.exploreByTouchHelper.sendEventForVirtualView(viewId, 1);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyItemActiveIndex() {
        Collection collection = this.items;
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean bl2 = false;
            for (BottomBarItem item : (Iterable)this.items) {
                void index;
                if (index == this.getItemActiveIndex()) {
                    this.animateAlpha(item, 255);
                } else {
                    this.animateAlpha(item, 0);
                }
                ++index;
            }
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.indicatorLocation, this.items.get((int)this.getItemActiveIndex()).getRect().left});
            bl = false;
            boolean bl3 = false;
            ValueAnimator $this$apply = valueAnimator;
            boolean bl4 = false;
            $this$apply.setDuration(this.getItemAnimDuration());
            $this$apply.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
            $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                final /* synthetic */ SmoothBottomBar this$0;
                {
                    this.this$0 = smoothBottomBar;
                }

                public final void onAnimationUpdate(ValueAnimator animation) {
                    ValueAnimator valueAnimator = animation;
                    Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animation");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    SmoothBottomBar.access$setIndicatorLocation$p(this.this$0, ((Float)object).floatValue());
                }
            });
            $this$apply.start();
            valueAnimator = ValueAnimator.ofObject((TypeEvaluator)((TypeEvaluator)new ArgbEvaluator()), (Object[])new Object[]{this.getItemIconTint(), this.getItemIconTintActive()});
            bl = false;
            bl3 = false;
            $this$apply = valueAnimator;
            boolean bl5 = false;
            $this$apply.setDuration(this.getItemAnimDuration());
            $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                final /* synthetic */ SmoothBottomBar this$0;
                {
                    this.this$0 = smoothBottomBar;
                }

                public final void onAnimationUpdate(ValueAnimator it) {
                    ValueAnimator valueAnimator = it;
                    Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
                    Object object = valueAnimator.getAnimatedValue();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    SmoothBottomBar.access$setCurrentIconTint$p(this.this$0, (Integer)object);
                }
            });
            $this$apply.start();
        }
    }

    private final void animateAlpha(BottomBarItem item, int to) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{item.getAlpha(), to});
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator;
        boolean bl3 = false;
        $this$apply.setDuration(this.getItemAnimDuration());
        $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, item){
            final /* synthetic */ SmoothBottomBar this$0;
            final /* synthetic */ BottomBarItem $item$inlined;
            {
                this.this$0 = smoothBottomBar;
                this.$item$inlined = bottomBarItem;
            }

            public final void onAnimationUpdate(ValueAnimator it) {
                ValueAnimator valueAnimator = it;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"it");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int value = (Integer)object;
                this.$item$inlined.setAlpha(value);
                this.this$0.invalidate();
            }
        });
        $this$apply.start();
    }

    public final void setupWithNavController(@NotNull Menu menu, @NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        NavigationComponentHelper.Companion.setupWithNavController(menu, this, navController);
    }

    public final void setOnItemSelectedListener(@NotNull Function1<? super Integer, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.onItemSelectedListener = new OnItemSelectedListener(listener){
            final /* synthetic */ Function1 $listener;

            public boolean onItemSelect(int pos) {
                this.$listener.invoke((Object)pos);
                return true;
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        };
    }

    public final void setOnItemReselectedListener(@NotNull Function1<? super Integer, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.onItemReselectedListener = new OnItemReselectedListener(listener){
            final /* synthetic */ Function1 $listener;

            public void onItemReselect(int pos) {
                this.$listener.invoke((Object)pos);
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        };
    }

    @JvmOverloads
    public SmoothBottomBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Paint $this$apply;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.currentIconTint = this.getItemIconTintActive();
        this.indicatorLocation = this.getBarSideMargins();
        this.rect = new RectF();
        boolean bl = false;
        this.items = CollectionsKt.emptyList();
        this._barBackgroundColor = -1;
        this._barIndicatorColor = Color.parseColor((String)DEFAULT_INDICATOR_COLOR);
        this._barIndicatorRadius = ContextExtKt.d2p(context, 20.0f);
        this._barSideMargins = ContextExtKt.d2p(context, 10.0f);
        this._barCornerRadius = ContextExtKt.d2p(context, 0.0f);
        this._itemPadding = ContextExtKt.d2p(context, 10.0f);
        this._itemAnimDuration = 200L;
        this._itemIconSize = ContextExtKt.d2p(context, 18.0f);
        this._itemIconMargin = ContextExtKt.d2p(context, 4.0f);
        this._itemIconTint = Color.parseColor((String)DEFAULT_TINT);
        this._itemIconTintActive = -1;
        this._itemTextColor = -1;
        this._itemTextSize = ContextExtKt.d2p(context, 11.0f);
        this._itemFontFamily = -1;
        this._itemMenuRes = -1;
        Paint paint = new Paint();
        boolean bl2 = false;
        boolean bl3 = false;
        Paint paint2 = paint;
        SmoothBottomBar smoothBottomBar = this;
        boolean bl4 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.getBarIndicatorColor());
        Unit unit = Unit.INSTANCE;
        smoothBottomBar.paintBackground = paint;
        paint = new Paint();
        bl2 = false;
        bl3 = false;
        $this$apply = paint;
        smoothBottomBar = this;
        boolean bl5 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.getBarIndicatorColor());
        unit = Unit.INSTANCE;
        smoothBottomBar.paintIndicator = paint;
        paint = new Paint();
        bl2 = false;
        bl3 = false;
        $this$apply = paint;
        smoothBottomBar = this;
        boolean bl6 = false;
        $this$apply.setAntiAlias(true);
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setColor(this.getItemTextColor());
        $this$apply.setTextSize(this.getItemTextSize());
        $this$apply.setTextAlign(Paint.Align.CENTER);
        $this$apply.setFakeBoldText(true);
        unit = Unit.INSTANCE;
        smoothBottomBar.paintText = paint;
        this.obtainStyledAttributes(attrs, defStyleAttr);
        this.exploreByTouchHelper = new AccessibleExploreByTouchHelper(this, this.items, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){

            public final void invoke(int p1) {
                ((SmoothBottomBar)((Object)this.receiver)).onClickAction(p1);
            }
        }));
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)((AccessibilityDelegateCompat)this.exploreByTouchHelper));
    }

    public /* synthetic */ SmoothBottomBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.SmoothBottomBarStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SmoothBottomBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SmoothBottomBar(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ float access$getIndicatorLocation$p(SmoothBottomBar $this) {
        return $this.indicatorLocation;
    }

    public static final /* synthetic */ void access$setIndicatorLocation$p(SmoothBottomBar $this, float f) {
        $this.indicatorLocation = f;
    }

    public static final /* synthetic */ int access$getCurrentIconTint$p(SmoothBottomBar $this) {
        return $this.currentIconTint;
    }

    public static final /* synthetic */ void access$setCurrentIconTint$p(SmoothBottomBar $this, int n) {
        $this.currentIconTint = n;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lme/ibrahimsn/lib/SmoothBottomBar$Companion;", "", "()V", "DEFAULT_ANIM_DURATION", "", "DEFAULT_BAR_CORNER_RADIUS", "", "DEFAULT_CORNER_RADIUS", "DEFAULT_ICON_MARGIN", "DEFAULT_ICON_SIZE", "DEFAULT_INDICATOR_COLOR", "", "DEFAULT_ITEM_PADDING", "DEFAULT_SIDE_MARGIN", "DEFAULT_TEXT_SIZE", "DEFAULT_TINT", "INVALID_RES", "", "OPAQUE", "TRANSPARENT", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

