/*
 * Decompiled with CFR 0.152.
 */
package com.bosong.frescozoomablelib.zoomable;

import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.bosong.frescozoomablelib.zoomable.AbstractAnimatedZoomableController;
import com.bosong.frescozoomablelib.zoomable.ZoomableDraweeView;

public class DoubleTapGestureListener
extends GestureDetector.SimpleOnGestureListener {
    private static final int DURATION_MS = 300;
    private static final int DOUBLE_TAP_SCROLL_THRESHOLD = 20;
    private final ZoomableDraweeView mDraweeView;
    private final PointF mDoubleTapViewPoint = new PointF();
    private final PointF mDoubleTapImagePoint = new PointF();
    private float mDoubleTapScale = 1.0f;
    private boolean mDoubleTapScroll = false;

    public DoubleTapGestureListener(ZoomableDraweeView zoomableDraweeView) {
        this.mDraweeView = zoomableDraweeView;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        AbstractAnimatedZoomableController zc = (AbstractAnimatedZoomableController)this.mDraweeView.getZoomableController();
        PointF vp = new PointF(e.getX(), e.getY());
        PointF ip = zc.mapViewToImage(vp);
        switch (e.getActionMasked()) {
            case 0: {
                this.mDoubleTapViewPoint.set(vp);
                this.mDoubleTapImagePoint.set(ip);
                this.mDoubleTapScale = zc.getScaleFactor();
                break;
            }
            case 2: {
                boolean bl = this.mDoubleTapScroll = this.mDoubleTapScroll || this.shouldStartDoubleTapScroll(vp);
                if (!this.mDoubleTapScroll) break;
                float scale = this.calcScale(vp);
                zc.zoomToPoint(scale, this.mDoubleTapImagePoint, this.mDoubleTapViewPoint);
                break;
            }
            case 1: {
                if (this.mDoubleTapScroll) {
                    float scale = this.calcScale(vp);
                    if (scale < 1.0f) {
                        zc.zoomToPoint(1.0f, this.mDoubleTapImagePoint, this.mDoubleTapViewPoint, 7, 300L, null);
                    } else {
                        zc.zoomToPoint(scale, this.mDoubleTapImagePoint, this.mDoubleTapViewPoint);
                    }
                } else {
                    float maxScale = zc.getMaxScaleFactor();
                    float minScale = zc.getMinScaleFactor();
                    if (zc.getScaleFactor() < (maxScale + minScale) / 2.0f) {
                        zc.zoomToPoint(maxScale, ip, vp, 7, 300L, null);
                    } else {
                        zc.zoomToPoint(1.0f, ip, vp, 7, 300L, null);
                    }
                }
                this.mDoubleTapScroll = false;
            }
        }
        return true;
    }

    private boolean shouldStartDoubleTapScroll(PointF viewPoint) {
        double dist = Math.hypot(viewPoint.x - this.mDoubleTapViewPoint.x, viewPoint.y - this.mDoubleTapViewPoint.y);
        return dist > 20.0;
    }

    private float calcScale(PointF currentViewPoint) {
        float dy = currentViewPoint.y - this.mDoubleTapViewPoint.y;
        float t = 1.0f + Math.abs(dy) * 0.001f;
        return dy < 0.0f ? this.mDoubleTapScale / t : this.mDoubleTapScale * t;
    }
}

