/*
 * Decompiled with CFR 0.152.
 */
package com.ymg.pdf.viewer.util;

import com.shockwave.pdfium.util.Size;
import com.shockwave.pdfium.util.SizeF;
import com.ymg.pdf.viewer.util.FitPolicy;

public class PageSizeCalculator {
    private FitPolicy fitPolicy;
    private final Size originalMaxWidthPageSize;
    private final Size originalMaxHeightPageSize;
    private final Size viewSize;
    private SizeF optimalMaxWidthPageSize;
    private SizeF optimalMaxHeightPageSize;
    private float widthRatio;
    private float heightRatio;
    private boolean fitEachPage;

    public PageSizeCalculator(FitPolicy fitPolicy, Size originalMaxWidthPageSize, Size originalMaxHeightPageSize, Size viewSize, boolean fitEachPage) {
        this.fitPolicy = fitPolicy;
        this.originalMaxWidthPageSize = originalMaxWidthPageSize;
        this.originalMaxHeightPageSize = originalMaxHeightPageSize;
        this.viewSize = viewSize;
        this.fitEachPage = fitEachPage;
        this.calculateMaxPages();
    }

    public SizeF calculate(Size pageSize) {
        if (pageSize.getWidth() <= 0 || pageSize.getHeight() <= 0) {
            return new SizeF(0.0f, 0.0f);
        }
        float maxWidth = this.fitEachPage ? (float)this.viewSize.getWidth() : (float)pageSize.getWidth() * this.widthRatio;
        float maxHeight = this.fitEachPage ? (float)this.viewSize.getHeight() : (float)pageSize.getHeight() * this.heightRatio;
        switch (this.fitPolicy) {
            case HEIGHT: {
                return this.fitHeight(pageSize, maxHeight);
            }
            case BOTH: {
                return this.fitBoth(pageSize, maxWidth, maxHeight);
            }
        }
        return this.fitWidth(pageSize, maxWidth);
    }

    public SizeF getOptimalMaxWidthPageSize() {
        return this.optimalMaxWidthPageSize;
    }

    public SizeF getOptimalMaxHeightPageSize() {
        return this.optimalMaxHeightPageSize;
    }

    private void calculateMaxPages() {
        switch (this.fitPolicy) {
            case HEIGHT: {
                this.optimalMaxHeightPageSize = this.fitHeight(this.originalMaxHeightPageSize, this.viewSize.getHeight());
                this.heightRatio = this.optimalMaxHeightPageSize.getHeight() / (float)this.originalMaxHeightPageSize.getHeight();
                this.optimalMaxWidthPageSize = this.fitHeight(this.originalMaxWidthPageSize, (float)this.originalMaxWidthPageSize.getHeight() * this.heightRatio);
                break;
            }
            case BOTH: {
                SizeF localOptimalMaxWidth = this.fitBoth(this.originalMaxWidthPageSize, this.viewSize.getWidth(), this.viewSize.getHeight());
                float localWidthRatio = localOptimalMaxWidth.getWidth() / (float)this.originalMaxWidthPageSize.getWidth();
                this.optimalMaxHeightPageSize = this.fitBoth(this.originalMaxHeightPageSize, (float)this.originalMaxHeightPageSize.getWidth() * localWidthRatio, this.viewSize.getHeight());
                this.heightRatio = this.optimalMaxHeightPageSize.getHeight() / (float)this.originalMaxHeightPageSize.getHeight();
                this.optimalMaxWidthPageSize = this.fitBoth(this.originalMaxWidthPageSize, this.viewSize.getWidth(), (float)this.originalMaxWidthPageSize.getHeight() * this.heightRatio);
                this.widthRatio = this.optimalMaxWidthPageSize.getWidth() / (float)this.originalMaxWidthPageSize.getWidth();
                break;
            }
            default: {
                this.optimalMaxWidthPageSize = this.fitWidth(this.originalMaxWidthPageSize, this.viewSize.getWidth());
                this.widthRatio = this.optimalMaxWidthPageSize.getWidth() / (float)this.originalMaxWidthPageSize.getWidth();
                this.optimalMaxHeightPageSize = this.fitWidth(this.originalMaxHeightPageSize, (float)this.originalMaxHeightPageSize.getWidth() * this.widthRatio);
            }
        }
    }

    private SizeF fitWidth(Size pageSize, float maxWidth) {
        float w = pageSize.getWidth();
        float h = pageSize.getHeight();
        float ratio = w / h;
        w = maxWidth;
        h = (float)Math.floor(maxWidth / ratio);
        return new SizeF(w, h);
    }

    private SizeF fitHeight(Size pageSize, float maxHeight) {
        float w = pageSize.getWidth();
        float h = pageSize.getHeight();
        float ratio = h / w;
        h = maxHeight;
        w = (float)Math.floor(maxHeight / ratio);
        return new SizeF(w, h);
    }

    private SizeF fitBoth(Size pageSize, float maxWidth, float maxHeight) {
        float w = pageSize.getWidth();
        float h = pageSize.getHeight();
        float ratio = w / h;
        w = maxWidth;
        h = (float)Math.floor(maxWidth / ratio);
        if (h > maxHeight) {
            h = maxHeight;
            w = (float)Math.floor(maxHeight * ratio);
        }
        return new SizeF(w, h);
    }
}

