/*
 * Decompiled with CFR 0.152.
 */
package iammert.com.expandablelib;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import iammert.com.expandablelib.ExpandCollapseListener;
import iammert.com.expandablelib.R;
import iammert.com.expandablelib.Section;
import java.util.ArrayList;
import java.util.List;

public class ExpandableLayout
extends LinearLayout {
    private static final int NO_RES = 0;
    private static final int NO_INDEX = -1;
    private LayoutInflater layoutInflater;
    @LayoutRes
    private int parentLayout;
    @LayoutRes
    private int childLayout;
    private Renderer renderer;
    private List<Section> sections;
    private ExpandCollapseListener.ExpandListener expandListener;
    private ExpandCollapseListener.CollapseListener collapseListener;

    public ExpandableLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public ExpandableLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ExpandableLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ExpandableLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.setOrientation(1);
        this.sections = new ArrayList<Section>();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ExpandableLayout);
        this.parentLayout = typedArray.getResourceId(R.styleable.ExpandableLayout_parentLayout, 0);
        this.childLayout = typedArray.getResourceId(R.styleable.ExpandableLayout_childLayout, 0);
        this.layoutInflater = LayoutInflater.from((Context)context);
        typedArray.recycle();
    }

    public <P> void setExpandListener(ExpandCollapseListener.ExpandListener<P> expandListener) {
        this.expandListener = expandListener;
    }

    public <P> void setCollapseListener(ExpandCollapseListener.CollapseListener<P> collapseListener) {
        this.collapseListener = collapseListener;
    }

    public void setRenderer(@NonNull Renderer renderer) {
        this.renderer = renderer;
    }

    public void addSection(@NonNull Section section) {
        this.sections.add(section);
        this.notifySectionAdded(section);
    }

    public <P, C> void addChild(P parent, C child) {
        int parentIndex = -1;
        for (int i = 0; i < this.sections.size(); ++i) {
            if (!this.sections.get((int)i).parent.equals(parent)) continue;
            this.sections.get((int)i).children.add(child);
            parentIndex = i;
        }
        if (parentIndex != -1) {
            this.notifyItemAdded(parentIndex, child);
        }
    }

    public <P, C> void addChildren(P parent, List<C> children) {
        int parentIndex = -1;
        for (int i = 0; i < this.sections.size(); ++i) {
            if (!this.sections.get((int)i).parent.equals(parent)) continue;
            this.sections.get((int)i).children.addAll(children);
            parentIndex = i;
        }
        if (parentIndex != -1) {
            this.notifyItemAdded(parentIndex, children);
        }
    }

    private <C> void notifyItemAdded(int parentIndex, C child) {
        if (this.renderer == null) {
            return;
        }
        ViewGroup parentView = (ViewGroup)this.getChildAt(parentIndex);
        View childView = this.layoutInflater.inflate(this.childLayout, null);
        this.renderer.renderChild(childView, child, parentIndex, this.sections.get((int)parentIndex).children.size() - 1);
        parentView.addView(childView);
    }

    private <C> void notifyItemAdded(int parentIndex, List<C> children) {
        if (this.renderer == null) {
            return;
        }
        ViewGroup parentView = (ViewGroup)this.getChildAt(parentIndex);
        for (int i = 0; i < children.size(); ++i) {
            View childView = this.layoutInflater.inflate(this.childLayout, null);
            this.renderer.renderChild(childView, children.get(i), parentIndex, i);
            parentView.addView(childView);
        }
    }

    private void notifySectionAdded(final Section section) {
        if (this.renderer == null) {
            return;
        }
        LinearLayout sectionLayout = new LinearLayout(this.getContext());
        sectionLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        sectionLayout.setOrientation(1);
        View parentView = this.layoutInflater.inflate(this.parentLayout, null);
        parentView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (section.expanded) {
                    ExpandableLayout.this.collapse(section.parent);
                } else {
                    ExpandableLayout.this.expand(section.parent);
                }
            }
        });
        this.renderer.renderParent(parentView, section.parent, section.expanded, this.sections.size() - 1);
        sectionLayout.addView(parentView);
        if (section.expanded) {
            for (int i = 0; i < section.children.size(); ++i) {
                Object child = section.children.get(i);
                View childView = this.layoutInflater.inflate(this.childLayout, null);
                this.renderer.renderChild(childView, child, this.sections.size() - 1, i);
                sectionLayout.addView(childView);
            }
        }
        this.addView((View)sectionLayout);
    }

    private <P> void expand(@NonNull P parent) {
        for (int i = 0; i < this.sections.size(); ++i) {
            if (!parent.equals(this.sections.get((int)i).parent)) continue;
            ViewGroup sectionView = (ViewGroup)this.getChildAt(i);
            sectionView.removeViews(1, sectionView.getChildCount() - 1);
            this.sections.get((int)i).expanded = true;
            this.notifyItemAdded(i, this.sections.get((int)i).children);
            if (this.expandListener == null) break;
            this.expandListener.onExpanded(i, this.sections.get((int)i).parent, sectionView.getChildAt(0));
            break;
        }
    }

    private <P> void collapse(@NonNull P parent) {
        for (int i = 0; i < this.sections.size(); ++i) {
            if (!parent.equals(this.sections.get((int)i).parent)) continue;
            ViewGroup sectionView = (ViewGroup)this.getChildAt(i);
            this.sections.get((int)i).expanded = false;
            sectionView.removeViews(1, sectionView.getChildCount() - 1);
            if (this.collapseListener == null) break;
            this.collapseListener.onCollapsed(i, this.sections.get((int)i).parent, sectionView.getChildAt(0));
            break;
        }
    }

    public static interface Renderer<P, C> {
        public void renderParent(View var1, P var2, boolean var3, int var4);

        public void renderChild(View var1, C var2, int var3, int var4);
    }
}

