/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer.persistable.io;

import com.ironz.binaryprefs.serialization.serializer.BooleanSerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteArraySerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteSerializer;
import com.ironz.binaryprefs.serialization.serializer.CharSerializer;
import com.ironz.binaryprefs.serialization.serializer.DoubleSerializer;
import com.ironz.binaryprefs.serialization.serializer.FloatSerializer;
import com.ironz.binaryprefs.serialization.serializer.IntegerSerializer;
import com.ironz.binaryprefs.serialization.serializer.LongSerializer;
import com.ironz.binaryprefs.serialization.serializer.ShortSerializer;
import com.ironz.binaryprefs.serialization.serializer.StringSerializer;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.io.DataOutput;

public final class PersistableObjectOutput
implements DataOutput {
    private static final int GROW_ARRAY_CAPACITY = 128;
    private static final int VERSION_STUB = 1;
    private final BooleanSerializer booleanSerializer;
    private final ByteSerializer byteSerializer;
    private final ByteArraySerializer byteArraySerializer;
    private final CharSerializer charSerializer;
    private final DoubleSerializer doubleSerializer;
    private final FloatSerializer floatSerializer;
    private final IntegerSerializer integerSerializer;
    private final LongSerializer longSerializer;
    private final ShortSerializer shortSerializer;
    private final StringSerializer stringSerializer;
    private int offset = 0;
    private byte[] buffer = new byte[128];

    public PersistableObjectOutput(BooleanSerializer booleanSerializer, ByteSerializer byteSerializer, ByteArraySerializer byteArraySerializer, CharSerializer charSerializer, DoubleSerializer doubleSerializer, FloatSerializer floatSerializer, IntegerSerializer integerSerializer, LongSerializer longSerializer, ShortSerializer shortSerializer, StringSerializer stringSerializer) {
        this.booleanSerializer = booleanSerializer;
        this.byteSerializer = byteSerializer;
        this.byteArraySerializer = byteArraySerializer;
        this.charSerializer = charSerializer;
        this.doubleSerializer = doubleSerializer;
        this.floatSerializer = floatSerializer;
        this.integerSerializer = integerSerializer;
        this.longSerializer = longSerializer;
        this.shortSerializer = shortSerializer;
        this.stringSerializer = stringSerializer;
    }

    @Override
    public byte[] serialize(Persistable value) {
        this.offset = 0;
        this.buffer = new byte[128];
        this.write(new byte[]{-11});
        this.writeInt(1);
        value.writeExternal(this);
        return this.trimFinalArray();
    }

    private byte[] trimFinalArray() {
        byte[] bytes = new byte[this.offset];
        System.arraycopy(this.buffer, 0, bytes, 0, this.offset);
        return bytes;
    }

    @Override
    public void writeBoolean(boolean value) {
        byte[] serialize = this.booleanSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeByte(byte value) {
        byte[] serialize = this.byteSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeByteArray(byte[] value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        byte[] serialize = this.byteArraySerializer.serialize(value);
        int length = serialize.length - this.byteArraySerializer.bytesLength();
        this.writeInt(length);
        this.write(serialize);
    }

    @Override
    public void writeShort(short value) {
        byte[] serialize = this.shortSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeChar(char value) {
        byte[] serialize = this.charSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeInt(int value) {
        byte[] serialize = this.integerSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeLong(long value) {
        byte[] serialize = this.longSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeFloat(float value) {
        byte[] serialize = this.floatSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeDouble(double value) {
        byte[] serialize = this.doubleSerializer.serialize(value);
        this.write(serialize);
    }

    @Override
    public void writeString(String value) {
        if (value == null) {
            this.writeInt(-1);
            return;
        }
        byte[] serialize = this.stringSerializer.serialize(value);
        int length = serialize.length - this.stringSerializer.bytesLength();
        this.writeInt(length);
        this.write(serialize);
    }

    private void write(byte[] value) {
        int length = value.length;
        this.tryGrowArray(length);
        System.arraycopy(value, 0, this.buffer, this.offset, length);
        this.offset += length;
    }

    private void tryGrowArray(int length) {
        boolean isOutOfBounds;
        boolean bl = isOutOfBounds = this.offset + length >= this.buffer.length - 1;
        if (isOutOfBounds) {
            this.growArray(length);
        }
    }

    private void growArray(int length) {
        int newLength = (this.buffer.length + length + 128) * 2;
        byte[] bytes = new byte[newLength];
        System.arraycopy(this.buffer, 0, bytes, 0, this.buffer.length);
        this.buffer = bytes;
    }
}

