/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.lock;

import com.ironz.binaryprefs.exception.LockOperationException;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

final class ProcessFileLock
implements Lock {
    private static final String RWD_MODE = "rwd";
    private final File lockFile;
    private RandomAccessFile randomAccessFile;
    private FileChannel channel;
    private FileLock lock;

    ProcessFileLock(File lockFile) {
        this.lockFile = lockFile;
    }

    @Override
    public void lock() {
        try {
            this.randomAccessFile = new RandomAccessFile(this.lockFile, RWD_MODE);
            this.channel = this.randomAccessFile.getChannel();
            this.lock = this.channel.lock();
        }
        catch (Exception e) {
            try {
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                }
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LockOperationException(e);
        }
    }

    @Override
    public void unlock() {
        try {
            if (this.lock != null && this.lock.isValid()) {
                this.lock.release();
            }
        }
        catch (Exception e) {
            throw new LockOperationException(e);
        }
        finally {
            try {
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                }
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public boolean tryLock() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

