/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.file.transaction;

import com.ironz.binaryprefs.encryption.KeyEncryption;
import com.ironz.binaryprefs.encryption.ValueEncryption;
import com.ironz.binaryprefs.file.adapter.FileAdapter;
import com.ironz.binaryprefs.file.transaction.FileTransaction;
import com.ironz.binaryprefs.file.transaction.TransactionElement;
import com.ironz.binaryprefs.lock.LockFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public final class MultiProcessTransaction
implements FileTransaction {
    private final FileAdapter fileAdapter;
    private final Lock lock;
    private final KeyEncryption keyEncryption;
    private final ValueEncryption valueEncryption;

    public MultiProcessTransaction(FileAdapter fileAdapter, LockFactory lockFactory, KeyEncryption keyEncryption, ValueEncryption valueEncryption) {
        this.fileAdapter = fileAdapter;
        this.lock = lockFactory.getProcessLock();
        this.valueEncryption = valueEncryption;
        this.keyEncryption = keyEncryption;
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public List<TransactionElement> fetchAll() {
        return this.fetchAllInternal();
    }

    @Override
    public Set<String> fetchNames() {
        return this.fetchNamesInternal();
    }

    @Override
    public TransactionElement fetchOne(String name) {
        return this.fetchOneInternal(name);
    }

    @Override
    public void commit(List<TransactionElement> elements) {
        this.commitInternal(elements);
    }

    private List<TransactionElement> fetchAllInternal() {
        String[] names = this.fileAdapter.names();
        ArrayList<TransactionElement> elements = new ArrayList<TransactionElement>(names.length);
        for (String name : names) {
            String decryptedName = this.keyEncryption.decrypt(name);
            TransactionElement element = this.fetchOneInternal(decryptedName);
            elements.add(element);
        }
        return elements;
    }

    private Set<String> fetchNamesInternal() {
        String[] names = this.fileAdapter.names();
        HashSet<String> temp = new HashSet<String>();
        for (String name : names) {
            String decrypt = this.keyEncryption.decrypt(name);
            temp.add(decrypt);
        }
        return temp;
    }

    private TransactionElement fetchOneInternal(String decryptedName) {
        String encryptName = this.keyEncryption.encrypt(decryptedName);
        byte[] content = this.fileAdapter.fetch(encryptName);
        byte[] decryptValue = this.valueEncryption.decrypt(content);
        return TransactionElement.createFetchElement(decryptedName, decryptValue);
    }

    private void commitInternal(List<TransactionElement> elements) {
        for (TransactionElement element : elements) {
            int action = element.getAction();
            String name = element.getName();
            String encryptedName = this.keyEncryption.encrypt(name);
            if (action == 2) {
                byte[] value = element.getContent();
                byte[] encryptedValue = this.valueEncryption.encrypt(value);
                this.fileAdapter.save(encryptedName, encryptedValue);
            }
            if (action != 3) continue;
            this.fileAdapter.remove(encryptedName);
        }
    }
}

