/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.task;

import com.ironz.binaryprefs.event.ExceptionHandler;
import com.ironz.binaryprefs.exception.FileOperationException;
import java.util.concurrent.Future;

public final class FutureBarrier {
    private final Future<?> future;
    private final ExceptionHandler exceptionHandler;

    FutureBarrier(Future<?> future, ExceptionHandler exceptionHandler) {
        this.future = future;
        this.exceptionHandler = exceptionHandler;
    }

    public boolean completeBlocking() {
        try {
            this.future.get();
            return true;
        }
        catch (Exception e) {
            this.exceptionHandler.handle(e);
            return false;
        }
    }

    public void completeBlockingUnsafe() {
        try {
            this.future.get();
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
    }
}

