/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.cache;

import com.ironz.binaryprefs.cache.CacheProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentCacheProviderImpl
implements CacheProvider {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final Map<String, Object> currentCache;

    public ConcurrentCacheProviderImpl(String prefName, Map<String, Map<String, Object>> allCaches) {
        this.currentCache = this.defineCache(prefName, allCaches);
    }

    private Map<String, Object> defineCache(String prefName, Map<String, Map<String, Object>> allCaches) {
        if (allCaches.containsKey(prefName)) {
            return allCaches.get(prefName);
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        allCaches.put(prefName, map);
        return map;
    }

    @Override
    public boolean contains(String key) {
        return this.currentCache.containsKey(key);
    }

    @Override
    public void put(String key, Object value) {
        this.currentCache.put(key, value);
    }

    @Override
    public String[] keys() {
        Set<String> keySet = this.currentCache.keySet();
        return keySet.toArray(EMPTY_ARRAY);
    }

    @Override
    public Object get(String key) {
        return this.currentCache.get(key);
    }

    @Override
    public void remove(String name) {
        this.currentCache.remove(name);
    }

    @Override
    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.currentCache);
    }
}

