/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.migration;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.PreferencesEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MigrateProcessor {
    private final List<SharedPreferences> migrate = new ArrayList<SharedPreferences>();

    public void add(SharedPreferences preferences) {
        this.migrate.add(preferences);
    }

    public void migrateTo(Preferences preferences) {
        for (SharedPreferences sharedPreferences : this.migrate) {
            this.applyOne(sharedPreferences, preferences);
        }
    }

    @SuppressLint(value={"ApplySharedPref"})
    private void applyOne(SharedPreferences from, Preferences to) {
        Map all = from.getAll();
        if (all.isEmpty()) {
            return;
        }
        PreferencesEditor editor = to.edit();
        for (String key : all.keySet()) {
            this.migrateValue(all, editor, key);
        }
        boolean commit = editor.commit();
        if (commit) {
            from.edit().clear().commit();
        }
    }

    private void migrateValue(Map<String, ?> all, PreferencesEditor editor, String key) {
        Object value = all.get(key);
        if (value instanceof String) {
            editor.putString(key, (String)value);
        }
        if (value instanceof Set) {
            editor.putStringSet(key, (Set)value);
        }
        if (value instanceof Integer) {
            editor.putInt(key, (Integer)value);
        }
        if (value instanceof Long) {
            editor.putLong(key, (Long)value);
        }
        if (value instanceof Float) {
            editor.putFloat(key, ((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            editor.putBoolean(key, (Boolean)value);
        }
    }
}

