/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.task;

import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.task.Completable;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class ScheduledBackgroundTaskExecutor
implements TaskExecutor {
    private final ExceptionHandler exceptionHandler;
    private static final Map<String, ExecutorService> executorsMap = new ConcurrentHashMap<String, ExecutorService>();
    private final ExecutorService executor;

    public ScheduledBackgroundTaskExecutor(String prefName, ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        this.executor = this.initExecutor(prefName);
    }

    private ExecutorService initExecutor(String prefName) {
        if (executorsMap.containsKey(prefName)) {
            return executorsMap.get(prefName);
        }
        ExecutorService service = Executors.newSingleThreadExecutor();
        executorsMap.put(prefName, service);
        return service;
    }

    @Override
    public synchronized Completable submit(Runnable runnable) {
        Future<?> submit = this.executor.submit(runnable);
        return new Completable(submit, this.exceptionHandler);
    }
}

