/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.file.directory;

import android.content.Context;
import com.ironz.binaryprefs.exception.FileOperationException;
import com.ironz.binaryprefs.file.directory.DirectoryProvider;
import java.io.File;

public final class AndroidDirectoryProviderImpl
implements DirectoryProvider {
    private static final String PREFERENCES = "preferences";
    private static final String VALUES = "values";
    private static final String BACKUP = "backup";
    private static final String LOCK = "lock";
    private final File storeDirectory;
    private final File backupDirectory;
    private final File lockDirectory;

    public AndroidDirectoryProviderImpl(Context context, String prefName) {
        this(context, prefName, false);
    }

    public AndroidDirectoryProviderImpl(Context context, String prefName, boolean saveInExternal) {
        File baseDir = this.defineCacheDir(context, saveInExternal);
        this.storeDirectory = this.createStoreDirectory(baseDir, prefName, VALUES);
        this.backupDirectory = this.createStoreDirectory(baseDir, prefName, BACKUP);
        this.lockDirectory = this.createStoreDirectory(baseDir, prefName, LOCK);
    }

    private File defineCacheDir(Context context, boolean saveInExternal) {
        return saveInExternal ? context.getExternalCacheDir() : context.getCacheDir();
    }

    private File createStoreDirectory(File baseDir, String prefName, String subDirectory) {
        String s = File.separator;
        File directory = new File(baseDir, s + PREFERENCES + s + prefName + s + subDirectory);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new FileOperationException(String.format("Cannot create preferences directory in %s", directory.getAbsolutePath()));
        }
        return directory;
    }

    @Override
    public File getStoreDirectory() {
        return this.storeDirectory;
    }

    @Override
    public File getBackupDirectory() {
        return this.backupDirectory;
    }

    @Override
    public File getLockDirectory() {
        return this.lockDirectory;
    }
}

