/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.encryption;

import com.ironz.binaryprefs.encryption.ByteEncryption;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesByteEncryptionImpl
implements ByteEncryption {
    private static final String AES = "AES";
    private static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5PADDING";
    private final byte[] secretKeyBytes;
    private final byte[] initialVector;

    public AesByteEncryptionImpl(byte[] secretKeyBytes, byte[] initialVector) {
        this.secretKeyBytes = secretKeyBytes;
        this.initialVector = initialVector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(byte[] bytes) {
        Class<AesByteEncryptionImpl> clazz = AesByteEncryptionImpl.class;
        synchronized (AesByteEncryptionImpl.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.encryptInternal(bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] bytes) {
        Class<AesByteEncryptionImpl> clazz = AesByteEncryptionImpl.class;
        synchronized (AesByteEncryptionImpl.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.decryptInternal(bytes);
        }
    }

    private byte[] encryptInternal(byte[] bytes) {
        try {
            Cipher encryptCipher = this.createEncryptCipher();
            return encryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] decryptInternal(byte[] bytes) {
        try {
            Cipher decryptCipher = this.createDecryptCipher();
            return decryptCipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Cipher createEncryptCipher() {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKeyBytes, AES);
            IvParameterSpec iv = new IvParameterSpec(this.initialVector);
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            cipher.init(1, (Key)secretKeySpec, iv);
            return cipher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Cipher createDecryptCipher() {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(this.secretKeyBytes, AES);
            IvParameterSpec iv = new IvParameterSpec(this.initialVector);
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            cipher.init(2, (Key)secretKeySpec, iv);
            return cipher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

