/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.task;

import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.exception.FileOperationException;
import java.util.concurrent.Future;

public final class Completable {
    private final Future<?> submit;
    private final ExceptionHandler exceptionHandler;

    public Completable(Future<?> submit, ExceptionHandler exceptionHandler) {
        this.submit = submit;
        this.exceptionHandler = exceptionHandler;
    }

    public boolean completeBlocking() {
        try {
            this.submit.get();
            return true;
        }
        catch (Exception e) {
            this.exceptionHandler.handle(e);
            return false;
        }
    }

    public void completeBlockingUnsafe() {
        try {
            this.submit.get();
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
    }
}

