/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer.persistable.io;

import com.ironz.binaryprefs.serialization.serializer.BooleanSerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteSerializer;
import com.ironz.binaryprefs.serialization.serializer.CharSerializer;
import com.ironz.binaryprefs.serialization.serializer.DoubleSerializer;
import com.ironz.binaryprefs.serialization.serializer.FloatSerializer;
import com.ironz.binaryprefs.serialization.serializer.IntegerSerializer;
import com.ironz.binaryprefs.serialization.serializer.LongSerializer;
import com.ironz.binaryprefs.serialization.serializer.ShortSerializer;
import com.ironz.binaryprefs.serialization.serializer.StringSerializer;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.io.DataInput;

public final class BinaryPrefsObjectInputImpl
implements DataInput {
    private final BooleanSerializer booleanSerializer;
    private final ByteSerializer byteSerializer;
    private final CharSerializer charSerializer;
    private final DoubleSerializer doubleSerializer;
    private final FloatSerializer floatSerializer;
    private final IntegerSerializer integerSerializer;
    private final LongSerializer longSerializer;
    private final ShortSerializer shortSerializer;
    private final StringSerializer stringSerializer;
    private int offset = 0;
    private byte[] buffer;

    public BinaryPrefsObjectInputImpl(BooleanSerializer booleanSerializer, ByteSerializer byteSerializer, CharSerializer charSerializer, DoubleSerializer doubleSerializer, FloatSerializer floatSerializer, IntegerSerializer integerSerializer, LongSerializer longSerializer, ShortSerializer shortSerializer, StringSerializer stringSerializer) {
        this.booleanSerializer = booleanSerializer;
        this.byteSerializer = byteSerializer;
        this.charSerializer = charSerializer;
        this.doubleSerializer = doubleSerializer;
        this.floatSerializer = floatSerializer;
        this.integerSerializer = integerSerializer;
        this.longSerializer = longSerializer;
        this.shortSerializer = shortSerializer;
        this.stringSerializer = stringSerializer;
    }

    @Override
    public <T extends Persistable> T deserialize(byte[] bytes, Class<T> clazz) {
        this.buffer = bytes;
        this.checkBytes();
        this.checkNull(clazz);
        ++this.offset;
        T instance = this.newInstance(clazz);
        instance.readExternal(this);
        return instance;
    }

    private <T extends Persistable> T newInstance(Class<T> clazz) {
        try {
            return (T)((Persistable)clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean readBoolean() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.booleanSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("boolean cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.booleanSerializer.bytesLength();
        boolean b = this.booleanSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return b;
    }

    @Override
    public byte readByte() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.byteSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("byte cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.byteSerializer.bytesLength();
        byte b = this.byteSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return b;
    }

    @Override
    public short readShort() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.shortSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("short cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.shortSerializer.bytesLength();
        short s = this.shortSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return s;
    }

    @Override
    public char readChar() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.charSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("char cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.charSerializer.bytesLength();
        char c = this.charSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return c;
    }

    @Override
    public int readInt() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.integerSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("int cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.integerSerializer.bytesLength();
        int i = this.integerSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return i;
    }

    @Override
    public long readLong() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.longSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("long cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.longSerializer.bytesLength();
        long l = this.longSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return l;
    }

    @Override
    public float readFloat() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.floatSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("float cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.floatSerializer.bytesLength();
        float f = this.floatSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return f;
    }

    @Override
    public double readDouble() {
        this.checkBounds();
        byte flag = this.buffer[this.offset];
        if (!this.doubleSerializer.isMatches(flag)) {
            throw new ClassCastException(String.format("double cannot be deserialized in '%s' flag type", flag));
        }
        int length = this.doubleSerializer.bytesLength();
        double d = this.doubleSerializer.deserialize(this.buffer, this.offset);
        this.offset += length;
        return d;
    }

    @Override
    public String readString() {
        int bytesStringSize = this.readInt();
        if (bytesStringSize == -1) {
            return null;
        }
        this.checkBounds();
        byte stringFlag = this.buffer[this.offset];
        if (!this.stringSerializer.isMatches(stringFlag)) {
            throw new ClassCastException(String.format("String cannot be deserialized in '%s' flag type", stringFlag));
        }
        String s = this.stringSerializer.deserialize(this.buffer, this.offset, bytesStringSize);
        this.offset += this.stringSerializer.bytesLength() + bytesStringSize;
        return s;
    }

    private void checkBounds() {
        if (this.offset >= this.buffer.length - 1) {
            throw new ArrayIndexOutOfBoundsException("Can't read out of bounds array");
        }
    }

    private void checkBytes() {
        if (this.buffer.length < 1) {
            throw new UnsupportedOperationException("Cannot deserialize empty byte array!");
        }
    }

    private void checkNull(Object value) {
        if (value == null) {
            throw new NullPointerException("Can't serialize null object");
        }
    }
}

