/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.cache;

import com.ironz.binaryprefs.cache.CacheProvider;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentCacheProviderImpl
implements CacheProvider {
    private static final Map<String, Map<String, Object>> caches = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Object> currentCache;

    public ConcurrentCacheProviderImpl(String name) {
        this.currentCache = this.initCaches(name);
    }

    private Map<String, Object> initCaches(String name) {
        if (caches.containsKey(name)) {
            return caches.get(name);
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        caches.put(name, map);
        return map;
    }

    @Override
    public boolean contains(String key) {
        return this.currentCache.containsKey(key);
    }

    @Override
    public void put(String key, Object value) {
        this.currentCache.put(key, value);
    }

    @Override
    public String[] keys() {
        return this.currentCache.keySet().toArray(new String[0]);
    }

    @Override
    public Object get(String key) {
        return this.currentCache.get(key);
    }

    @Override
    public void remove(String name) {
        this.currentCache.remove(name);
    }

    @Override
    public Map<String, Object> getAll() {
        return Collections.unmodifiableMap(this.currentCache);
    }
}

