/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.serialization.serializer.persistable.io;

import com.ironz.binaryprefs.serialization.serializer.BooleanSerializer;
import com.ironz.binaryprefs.serialization.serializer.ByteSerializer;
import com.ironz.binaryprefs.serialization.serializer.CharSerializer;
import com.ironz.binaryprefs.serialization.serializer.DoubleSerializer;
import com.ironz.binaryprefs.serialization.serializer.FloatSerializer;
import com.ironz.binaryprefs.serialization.serializer.IntegerSerializer;
import com.ironz.binaryprefs.serialization.serializer.LongSerializer;
import com.ironz.binaryprefs.serialization.serializer.ShortSerializer;
import com.ironz.binaryprefs.serialization.serializer.StringSerializer;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.serialization.serializer.persistable.io.DataOutput;

public final class BinaryPrefsObjectOutputImpl
implements DataOutput {
    private static final int GROW_ARRAY_CAPACITY = 128;
    private final BooleanSerializer booleanSerializer;
    private final ByteSerializer byteSerializer;
    private final CharSerializer charSerializer;
    private final DoubleSerializer doubleSerializer;
    private final FloatSerializer floatSerializer;
    private final IntegerSerializer integerSerializer;
    private final LongSerializer longSerializer;
    private final ShortSerializer shortSerializer;
    private final StringSerializer stringSerializer;
    private int offset = 0;
    private byte[] buffer = new byte[128];

    public BinaryPrefsObjectOutputImpl(BooleanSerializer booleanSerializer, ByteSerializer byteSerializer, CharSerializer charSerializer, DoubleSerializer doubleSerializer, FloatSerializer floatSerializer, IntegerSerializer integerSerializer, LongSerializer longSerializer, ShortSerializer shortSerializer, StringSerializer stringSerializer) {
        this.booleanSerializer = booleanSerializer;
        this.byteSerializer = byteSerializer;
        this.charSerializer = charSerializer;
        this.doubleSerializer = doubleSerializer;
        this.floatSerializer = floatSerializer;
        this.integerSerializer = integerSerializer;
        this.longSerializer = longSerializer;
        this.shortSerializer = shortSerializer;
        this.stringSerializer = stringSerializer;
    }

    @Override
    public <T extends Persistable> byte[] serialize(T value) {
        this.write(new byte[]{-11});
        value.writeExternal(this);
        byte[] bytes = new byte[this.offset];
        System.arraycopy(this.buffer, 0, bytes, 0, this.offset);
        return bytes;
    }

    @Override
    public void writeBoolean(boolean value) {
        this.write(this.booleanSerializer.serialize(value));
    }

    @Override
    public void writeByte(int value) {
        this.write(this.byteSerializer.serialize((byte)value));
    }

    @Override
    public void writeShort(int value) {
        this.write(this.shortSerializer.serialize((short)value));
    }

    @Override
    public void writeChar(int value) {
        this.write(this.charSerializer.serialize((char)value));
    }

    @Override
    public void writeInt(int value) {
        this.write(this.integerSerializer.serialize(value));
    }

    @Override
    public void writeLong(long value) {
        this.write(this.longSerializer.serialize(value));
    }

    @Override
    public void writeFloat(float value) {
        this.write(this.floatSerializer.serialize(value));
    }

    @Override
    public void writeDouble(double value) {
        this.write(this.doubleSerializer.serialize(value));
    }

    @Override
    public void writeString(String s) {
        if (s == null) {
            throw new NullPointerException("String for serialization cannot be null");
        }
        this.writeInt(s.length());
        this.write(this.stringSerializer.serialize(s));
    }

    private void write(byte[] value) {
        int length = value.length;
        this.tryGrowArray(length);
        System.arraycopy(value, 0, this.buffer, this.offset, length);
        this.offset += length;
    }

    private void tryGrowArray(int len) {
        if (this.offset + len >= this.buffer.length - 1) {
            this.growArray(len);
        }
    }

    private void growArray(int len) {
        int newLength = (this.buffer.length + len + 128) * 2;
        byte[] bytes = new byte[newLength];
        System.arraycopy(this.buffer, 0, bytes, 0, this.buffer.length);
        this.buffer = bytes;
    }
}

