/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.lock;

import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.file.directory.DirectoryProvider;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.lock.global.FileGlobalLockFactoryImpl;
import com.ironz.binaryprefs.lock.global.GlobalLockFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class SimpleLockFactoryImpl
implements LockFactory {
    private final Map<String, ReadWriteLock> locks = new HashMap<String, ReadWriteLock>();
    private GlobalLockFactory globalLockFactory;

    public SimpleLockFactoryImpl(DirectoryProvider directoryProvider, ExceptionHandler exceptionHandler) {
        this.globalLockFactory = new FileGlobalLockFactoryImpl(directoryProvider, exceptionHandler);
    }

    @Override
    public Lock getReadLock(String name) {
        if (this.locks.containsKey(name)) {
            ReadWriteLock readWriteLock = this.locks.get(name);
            return readWriteLock.readLock();
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.locks.put(name, lock);
        return lock.readLock();
    }

    @Override
    public Lock getWriteLock(String name) {
        if (this.locks.containsKey(name)) {
            ReadWriteLock readWriteLock = this.locks.get(name);
            return readWriteLock.writeLock();
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.locks.put(name, lock);
        return lock.writeLock();
    }

    @Override
    public GlobalLockFactory getGlobalLockFactory() {
        return this.globalLockFactory;
    }
}

