/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs;

import android.content.SharedPreferences;
import com.ironz.binaryprefs.BinaryPreferencesEditor;
import com.ironz.binaryprefs.Preferences;
import com.ironz.binaryprefs.PreferencesEditor;
import com.ironz.binaryprefs.cache.CacheProvider;
import com.ironz.binaryprefs.events.EventBridge;
import com.ironz.binaryprefs.exception.ExceptionHandler;
import com.ironz.binaryprefs.file.FileAdapter;
import com.ironz.binaryprefs.lock.LockFactory;
import com.ironz.binaryprefs.lock.global.GlobalLockFactory;
import com.ironz.binaryprefs.serialization.SerializerFactory;
import com.ironz.binaryprefs.serialization.serializer.persistable.Persistable;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public final class BinaryPreferences
implements Preferences {
    private final FileAdapter fileAdapter;
    private final ExceptionHandler exceptionHandler;
    private final EventBridge eventsBridge;
    private final CacheProvider cacheProvider;
    private final TaskExecutor taskExecutor;
    private final SerializerFactory serializerFactory;
    private final Lock readLock;
    private final Lock writeLock;
    private final GlobalLockFactory globalLockFactory;

    public BinaryPreferences(String prefName, FileAdapter fileAdapter, ExceptionHandler exceptionHandler, EventBridge eventsBridge, CacheProvider cacheProvider, TaskExecutor taskExecutor, SerializerFactory serializerFactory, LockFactory lockFactory) {
        this.fileAdapter = fileAdapter;
        this.exceptionHandler = exceptionHandler;
        this.eventsBridge = eventsBridge;
        this.cacheProvider = cacheProvider;
        this.taskExecutor = taskExecutor;
        this.serializerFactory = serializerFactory;
        this.readLock = lockFactory.getReadLock(prefName);
        this.writeLock = lockFactory.getWriteLock(prefName);
        this.globalLockFactory = lockFactory.getGlobalLockFactory();
        this.fetchCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchCache() {
        this.readLock.lock();
        Lock lock = this.globalLockFactory.getLock();
        lock.lock();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            for (String name : this.fileAdapter.names()) {
                byte[] bytes = this.fileAdapter.fetch(name);
                Object o = this.serializerFactory.deserialize(name, bytes);
                map.put(name, o);
            }
            for (String name : map.keySet()) {
                this.cacheProvider.put(name, map.get(name));
            }
        }
        finally {
            lock.lock();
            this.readLock.unlock();
        }
    }

    public Map<String, Object> getAll() {
        this.readLock.lock();
        try {
            Map<String, Object> map = this.cacheProvider.getAll();
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                String string = (String)this.cacheProvider.get(key);
                return string;
            }
            String string = defValue;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getStringSet(String key, Set<String> defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                Set strings = (Set)this.cacheProvider.get(key);
                HashSet<String> hashSet = new HashSet<String>(strings);
                return hashSet;
            }
            Set<String> set = defValue;
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                int n = (Integer)this.cacheProvider.get(key);
                return n;
            }
            int n = defValue;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                long l = (Long)this.cacheProvider.get(key);
                return l;
            }
            long l = defValue;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                float f = ((Float)this.cacheProvider.get(key)).floatValue();
                return f;
            }
            float f = defValue;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                boolean bl = (Boolean)this.cacheProvider.get(key);
                return bl;
            }
            boolean bl = defValue;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Persistable> T getPersistable(String key, T defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                Persistable t = (Persistable)this.cacheProvider.get(key);
                Persistable persistable = t.deepCopy();
                return (T)persistable;
            }
            T t = defValue;
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String key, byte defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                byte by = (Byte)this.cacheProvider.get(key);
                return by;
            }
            byte by = defValue;
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String key, short defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                short s = (Short)this.cacheProvider.get(key);
                return s;
            }
            short s = defValue;
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char getChar(String key, char defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                char c = ((Character)this.cacheProvider.get(key)).charValue();
                return c;
            }
            char c = defValue;
            return c;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String key, double defValue) {
        this.readLock.lock();
        try {
            if (this.cacheProvider.contains(key)) {
                double d = (Double)this.cacheProvider.get(key);
                return d;
            }
            double d = defValue;
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(String key) {
        this.readLock.lock();
        try {
            boolean bl = this.cacheProvider.contains(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public PreferencesEditor edit() {
        this.readLock.lock();
        try {
            BinaryPreferencesEditor binaryPreferencesEditor = new BinaryPreferencesEditor(this, this.fileAdapter, this.exceptionHandler, this.eventsBridge, this.taskExecutor, this.serializerFactory, this.cacheProvider, this.writeLock, this.globalLockFactory);
            return binaryPreferencesEditor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.writeLock.lock();
        try {
            this.eventsBridge.registerOnSharedPreferenceChangeListener(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.writeLock.lock();
        try {
            this.eventsBridge.unregisterOnSharedPreferenceChangeListener(listener);
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

