/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.util;

import java.util.HashSet;
import java.util.Set;

public final class Bits {
    static final byte FLAG_STRING_SET = -10;
    static final byte FLAG_STRING = -20;
    static final byte FLAG_INT = -30;
    static final byte FLAG_LONG = -40;
    static final byte FLAG_FLOAT = -50;
    static final byte FLAG_BOOLEAN = -60;
    private static final int INITIAL_INTEGER_LENGTH = 5;
    private static final int NULL_STRING_SIZE = -1;

    private Bits() {
    }

    public static byte[] stringSetToBytesWithFlag(Set<String> value) {
        byte[][] bytes = new byte[value.size()][];
        int i = 0;
        int totalArraySize = 1;
        for (String s : value) {
            byte[] stringBytes = s == null ? new byte[]{} : s.getBytes();
            byte[] stringSizeBytes = s == null ? Bits.intToBytesWithFlag(-1) : Bits.intToBytesWithFlag(stringBytes.length);
            byte[] merged = new byte[stringBytes.length + stringSizeBytes.length];
            System.arraycopy(stringSizeBytes, 0, merged, 0, stringSizeBytes.length);
            System.arraycopy(stringBytes, 0, merged, stringSizeBytes.length, stringBytes.length);
            bytes[i] = merged;
            totalArraySize += merged.length;
            ++i;
        }
        byte[] totalArray = new byte[totalArraySize];
        totalArray[0] = -10;
        int offset = 1;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, totalArray, offset, b.length);
            offset += b.length;
        }
        return totalArray;
    }

    public static Set<String> stringSetFromBytesWithFlag(byte[] bytes) {
        byte flag = bytes[0];
        if (flag == -10) {
            if (bytes.length == 1) {
                return new HashSet<String>(0);
            }
            HashSet<String> set = new HashSet<String>();
            int i = 1;
            while (i < bytes.length) {
                byte[] stringSizeBytes = new byte[]{bytes[i], bytes[i + 1], bytes[i + 2], bytes[i + 3], bytes[i + 4]};
                int stringSize = Bits.intFromBytesWithFlag(stringSizeBytes);
                if (stringSize == -1) {
                    set.add(null);
                    i += 5;
                    continue;
                }
                byte[] stringBytes = new byte[stringSize];
                for (int k = 0; k < stringBytes.length; ++k) {
                    int offset = i + k + 5;
                    stringBytes[k] = bytes[offset];
                }
                set.add(new String(stringBytes));
                i += 5 + stringSize;
            }
            return set;
        }
        throw new ClassCastException(String.format("Set<String> cannot be deserialized in '%s' flag type", flag));
    }

    public static byte[] stringToBytesWithFlag(String value) {
        byte[] stringBytes = value.getBytes();
        int flagSize = 1;
        byte[] b = new byte[stringBytes.length + flagSize];
        b[0] = -20;
        System.arraycopy(stringBytes, 0, b, flagSize, stringBytes.length);
        return b;
    }

    public static String stringFromBytesWithFlag(byte[] bytes) {
        byte flag = bytes[0];
        if (flag == -20) {
            int lengthWithoutFlag = bytes.length - 1;
            return new String(bytes, 1, lengthWithoutFlag);
        }
        throw new ClassCastException(String.format("String cannot be deserialized in '%s' flag type", flag));
    }

    public static byte[] intToBytesWithFlag(int value) {
        return new byte[]{-30, (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static int intFromBytesWithFlag(byte[] bytes) {
        int i = 255;
        byte flag = bytes[0];
        if (flag == -30) {
            return (bytes[4] & i) + ((bytes[3] & i) << 8) + ((bytes[2] & i) << 16) + (bytes[1] << 24);
        }
        throw new ClassCastException(String.format("int cannot be deserialized in '%s' flag type", flag));
    }

    public static byte[] floatToBytesWithFlag(float value) {
        int i = Float.floatToIntBits(value);
        return new byte[]{-50, (byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)value};
    }

    public static float floatFromBytesWithFlag(byte[] bytes) {
        int i = 255;
        byte flag = bytes[0];
        if (flag == -50) {
            int value = (bytes[4] & i) + ((bytes[3] & i) << 8) + ((bytes[2] & i) << 16) + (bytes[1] << 24);
            return Float.intBitsToFloat(value);
        }
        throw new ClassCastException(String.format("float cannot be deserialized in '%s' flag type", flag));
    }

    public static byte[] longToBytesWithFlag(long value) {
        return new byte[]{-40, (byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static long longFromBytesWithFlag(byte[] bytes) {
        long l = 255L;
        byte flag = bytes[0];
        if (flag == -40) {
            return ((long)bytes[8] & l) + (((long)bytes[7] & l) << 8) + (((long)bytes[6] & l) << 16) + (((long)bytes[5] & l) << 24) + (((long)bytes[4] & l) << 32) + (((long)bytes[3] & l) << 40) + (((long)bytes[2] & l) << 48) + ((long)bytes[1] << 56);
        }
        throw new ClassCastException(String.format("long cannot be deserialized in '%s' flag type", flag));
    }

    public static byte[] booleanToBytesWithFlag(boolean value) {
        return new byte[]{-60, (byte)(value ? 1 : 0)};
    }

    public static boolean booleanFromBytesWithFlag(byte[] bytes) {
        byte flag = bytes[0];
        if (flag == -60) {
            return bytes[1] != 0;
        }
        throw new ClassCastException(String.format("boolean cannot be deserialized in '%s' flag type", flag));
    }

    public static Object tryDeserializeByFlag(byte[] bytes) {
        byte flag = bytes[0];
        if (flag == -10) {
            return Bits.stringSetFromBytesWithFlag(bytes);
        }
        if (flag == -20) {
            return Bits.stringFromBytesWithFlag(bytes);
        }
        if (flag == -30) {
            return Bits.intFromBytesWithFlag(bytes);
        }
        if (flag == -40) {
            return Bits.longFromBytesWithFlag(bytes);
        }
        if (flag == -50) {
            return Float.valueOf(Bits.floatFromBytesWithFlag(bytes));
        }
        if (flag == -60) {
            return Bits.booleanFromBytesWithFlag(bytes);
        }
        throw new UnsupportedClassVersionError(String.format("Flag verification failed. Incorrect type '%s'", flag));
    }
}

