/*
 * Decompiled with CFR 0.152.
 */
package com.ironz.binaryprefs.file;

import com.ironz.binaryprefs.encryption.ByteEncryption;
import com.ironz.binaryprefs.exception.FileOperationException;
import com.ironz.binaryprefs.file.DirectoryProvider;
import com.ironz.binaryprefs.file.FileAdapter;
import com.ironz.binaryprefs.task.TaskExecutor;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.Map;

public final class NioFileAdapter
implements FileAdapter {
    final File srcDir;
    private final TaskExecutor taskExecutor;
    private final ByteEncryption encryption;
    private final Map<String, byte[]> cache = new HashMap<String, byte[]>();

    public NioFileAdapter(DirectoryProvider directoryProvider) {
        this(directoryProvider, TaskExecutor.DEFAULT);
    }

    public NioFileAdapter(DirectoryProvider directoryProvider, TaskExecutor taskExecutor) {
        this(directoryProvider, taskExecutor, ByteEncryption.NO_OP);
    }

    public NioFileAdapter(DirectoryProvider directoryProvider, TaskExecutor taskExecutor, ByteEncryption byteEncryption) {
        this(directoryProvider.getBaseDirectory(), taskExecutor, byteEncryption);
    }

    private NioFileAdapter(File srcDir, TaskExecutor taskExecutor, ByteEncryption encryption) {
        this.srcDir = srcDir;
        this.taskExecutor = taskExecutor;
        this.encryption = encryption;
        this.defineCache();
    }

    private void defineCache() {
        for (String name : this.getFileNamesInternal()) {
            File file = new File(this.srcDir, name);
            byte[] bytes = this.fetchInternal(file);
            byte[] decrypt = this.encryption.decrypt(bytes);
            this.cache.put(name, decrypt);
        }
    }

    private String[] getFileNamesInternal() {
        String[] list = this.srcDir.list();
        if (list != null) {
            return list;
        }
        return new String[0];
    }

    @Override
    public String[] names() {
        return this.cache.keySet().toArray(new String[0]);
    }

    @Override
    public byte[] fetch(String name) {
        return this.cache.get(name);
    }

    private byte[] fetchInternal(File file) {
        FileChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            channel = randomAccessFile.getChannel();
            int size = (int)randomAccessFile.length();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            byte[] bytes = new byte[size];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void save(final String name, final byte[] bytes) {
        this.cache.put(name, bytes);
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                File file = new File(NioFileAdapter.this.srcDir, name);
                byte[] encrypt = NioFileAdapter.this.encryption.encrypt(bytes);
                NioFileAdapter.this.saveInternal(file, encrypt);
            }
        });
    }

    private void saveInternal(File file, byte[] bytes) {
        AbstractInterruptibleChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rwd");
            randomAccessFile.setLength(0L);
            channel = randomAccessFile.getChannel();
            MappedByteBuffer byteBuffer = ((FileChannel)channel).map(FileChannel.MapMode.READ_WRITE, 0L, bytes.length);
            byteBuffer.put(bytes);
            ((FileChannel)channel).write(byteBuffer);
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (channel != null) {
                    channel.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                NioFileAdapter.this.clearInternal();
            }
        });
    }

    private void clearInternal() {
        try {
            for (String name : this.names()) {
                File file = new File(this.srcDir, name);
                file.delete();
            }
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
    }

    @Override
    public void remove(final String name) {
        this.cache.remove(name);
        this.taskExecutor.submit(new Runnable(){

            @Override
            public void run() {
                NioFileAdapter.this.removeInternal(name);
            }
        });
    }

    private void removeInternal(String name) {
        try {
            File file = new File(this.srcDir, name);
            file.delete();
        }
        catch (Exception e) {
            throw new FileOperationException(e);
        }
    }

    @Override
    public boolean contains(String name) {
        return this.cache.containsKey(name);
    }
}

