/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.IOException;
import java.io.InputStream;
import site.iway.javahelpers.AutoExpandByteArray;

public class StreamReader {
    public static byte[] readAllBytes(InputStream stream, int bufferSize, int limit) throws IOException {
        int readCount;
        AutoExpandByteArray autoExpandByteArray = new AutoExpandByteArray(bufferSize);
        byte[] buffer = new byte[bufferSize];
        int totalRead = 0;
        while ((readCount = stream.read(buffer)) > -1) {
            if (limit > 0 && (totalRead += readCount) > limit) {
                throw new IOException("Content length exceeding limit.");
            }
            autoExpandByteArray.add(buffer, 0, readCount);
        }
        return autoExpandByteArray.getOutArray();
    }

    public static byte[] readAllBytes(InputStream stream, int bufferSize) throws IOException {
        return StreamReader.readAllBytes(stream, bufferSize, 0);
    }

    public static byte[] readAllBytes(InputStream stream) throws IOException {
        return StreamReader.readAllBytes(stream, 8192);
    }

    public static byte[] readBytesByCount(InputStream stream, int count) throws IOException {
        byte[] result = new byte[count];
        for (int offset = 0; offset != count; offset += stream.read(result, offset, count - offset)) {
        }
        return result;
    }
}

