/*
 * Decompiled with CFR 0.152.
 */
package site.iway.javahelpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileSystemHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dst, boolean overwrite) {
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int readCount;
            inputStream = new FileInputStream(src);
            if (dst.exists() && !overwrite) {
                throw new IOException("File dst already existed but can not be overwritten.");
            }
            outputStream = new FileOutputStream(dst);
            byte[] buffer = new byte[8192];
            while ((readCount = ((InputStream)inputStream).read(buffer)) > -1) {
                outputStream.write(buffer, 0, readCount);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean copyFile(File src, File dst) {
        return FileSystemHelper.copyFile(src, dst, true);
    }

    public static boolean copyFile(String src, String dst, boolean overwrite) {
        return FileSystemHelper.copyFile(new File(src), new File(dst), overwrite);
    }

    public static boolean copyFile(String src, String dst) {
        return FileSystemHelper.copyFile(src, dst, true);
    }

    public static boolean createDirectory(File directory) {
        if (directory.exists()) {
            return directory.isDirectory();
        }
        return directory.mkdirs();
    }

    public static boolean createDirectory(String directory) {
        return FileSystemHelper.createDirectory(new File(directory));
    }

    public static boolean deleteDirectory(File directory) {
        boolean allDeleted = true;
        if (directory.exists()) {
            File[] subFiles = directory.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    if (subFile.isDirectory()) {
                        allDeleted &= FileSystemHelper.deleteDirectory(directory);
                    }
                    if (!subFile.isFile()) continue;
                    allDeleted &= subFile.delete();
                }
            }
            allDeleted &= directory.delete();
        }
        return allDeleted;
    }

    public static boolean deleteDirectory(String directory) {
        return FileSystemHelper.deleteDirectory(new File(directory));
    }

    public static boolean cleanDirectory(File directory) {
        return FileSystemHelper.deleteDirectory(directory) && FileSystemHelper.createDirectory(directory);
    }

    public static boolean cleanDirectory(String directory) {
        return FileSystemHelper.cleanDirectory(new File(directory));
    }
}

